/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

public class NewLeafUpdater
implements Updater {
    private final ChunkSection section;
    private boolean forceOldSystem;

    @Override
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        if (state.getBlockId() == 161) {
            boolean oldSystemForSure;
            int legacyDamage = state.getLegacyDamage();
            if ((legacyDamage & 0xE) == 0) {
                return false;
            }
            boolean newSystemForSure = (legacyDamage & 8) == 8;
            boolean bl = oldSystemForSure = (legacyDamage & 2) == 2;
            if (newSystemForSure && oldSystemForSure) {
                int newData = legacyDamage & 1;
                BlockState fixed = state.withData(newData |= 8);
                this.section.setBlockState(x, y, z, fixed);
                return true;
            }
            if (newSystemForSure) {
                return false;
            }
            if (this.forceOldSystem || oldSystemForSure) {
                boolean persistent;
                int newData = legacyDamage & 1;
                boolean bl2 = persistent = (legacyDamage & 4) == 4;
                if (persistent) {
                    newData |= 4;
                }
                if (oldSystemForSure || !persistent) {
                    newData |= 8;
                }
                BlockState fixed = state.withData(newData);
                if (newData == legacyDamage) {
                    return false;
                }
                this.section.setBlockState(x, y, z, fixed);
                return true;
            }
        }
        return false;
    }

    public NewLeafUpdater(ChunkSection section) {
        this.section = section;
    }

    public boolean isForceOldSystem() {
        return this.forceOldSystem;
    }

    public void setForceOldSystem(boolean forceOldSystem) {
        this.forceOldSystem = forceOldSystem;
    }
}

