/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.ObjectSpruceTree;
import cn.nukkit.math.NukkitRandom;

public class ObjectBigSpruceTree
extends ObjectSpruceTree {
    private final float leafStartHeightMultiplier;
    private final int baseLeafRadius;

    public ObjectBigSpruceTree(float leafStartHeightMultiplier, int baseLeafRadius) {
        this.leafStartHeightMultiplier = leafStartHeightMultiplier;
        this.baseLeafRadius = baseLeafRadius;
    }

    @Override
    public void placeObject(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        this.treeHeight = random.nextBoundedInt(15) + 20;
        int topSize = this.treeHeight - (int)((float)this.treeHeight * this.leafStartHeightMultiplier);
        int lRadius = this.baseLeafRadius + random.nextBoundedInt(2);
        this.placeTrunk(level, x, y, z, random, this.getTreeHeight() - random.nextBoundedInt(3));
        this.placeLeaves(level, topSize, lRadius, x, y, z, random);
    }

    @Override
    protected void placeTrunk(ChunkManager level, int x, int y, int z, NukkitRandom random, int trunkHeight) {
        level.setBlockAt(x, y - 1, z, 3);
        int radius = 2;
        for (int yy = 0; yy < trunkHeight; ++yy) {
            for (int xx = 0; xx < radius; ++xx) {
                for (int zz = 0; zz < radius; ++zz) {
                    int blockId = level.getBlockIdAt(x, y + yy, z);
                    if (!this.overridable(blockId)) continue;
                    level.setBlockAt(x + xx, y + yy, z + zz, this.getTrunkBlock(), this.getType());
                }
            }
        }
    }
}

