/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.type;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.helper.PopulatorHelpers;
import cn.nukkit.level.generator.populator.type.PopulatorCount;
import cn.nukkit.math.NukkitRandom;

public abstract class PopulatorSurfaceBlock
extends PopulatorCount {
    @Override
    protected void populateCount(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int z;
        int x = random.nextBoundedInt(16);
        int y = this.getHighestWorkableBlock(level, x, z = random.nextBoundedInt(16), chunk);
        if (y > 0 && this.canStay(x, y, z, chunk)) {
            this.placeBlock(x, y, z, this.getBlockId(x, z, random, chunk), chunk, random);
        }
    }

    protected abstract boolean canStay(int var1, int var2, int var3, FullChunk var4);

    protected abstract int getBlockId(int var1, int var2, NukkitRandom var3, FullChunk var4);

    @Override
    protected int getHighestWorkableBlock(ChunkManager level, int x, int z, FullChunk chunk) {
        int y;
        for (y = 254; y >= 0 && PopulatorHelpers.isNonSolid(chunk.getBlockId(x, y, z)); --y) {
        }
        return y == 0 ? -1 : ++y;
    }

    protected void placeBlock(int x, int y, int z, int id, FullChunk chunk, NukkitRandom random) {
        chunk.setFullBlockId(x, y, z, id);
    }
}

