/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.task;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.SimpleChunkManager;
import cn.nukkit.scheduler.AsyncTask;

public class GenerationTask
extends AsyncTask {
    private final Level level;
    public boolean state = true;
    private BaseFullChunk chunk;

    public GenerationTask(Level level, BaseFullChunk chunk) {
        this.chunk = chunk;
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRun() {
        Generator generator = this.level.getGenerator();
        this.state = false;
        if (generator == null) {
            return;
        }
        SimpleChunkManager manager = (SimpleChunkManager)generator.getChunkManager();
        if (manager == null) {
            this.state = false;
            return;
        }
        manager.cleanChunks(this.level.getSeed());
        SimpleChunkManager simpleChunkManager = manager;
        synchronized (simpleChunkManager) {
            try {
                BaseFullChunk chunk = this.chunk;
                if (chunk == null) {
                    return;
                }
                BaseFullChunk baseFullChunk = chunk;
                synchronized (baseFullChunk) {
                    if (!chunk.isGenerated()) {
                        manager.setChunk(chunk.getX(), chunk.getZ(), chunk);
                        generator.generateChunk(chunk.getX(), chunk.getZ());
                        chunk = manager.getChunk(chunk.getX(), chunk.getZ());
                        chunk.setGenerated();
                    }
                }
                this.chunk = chunk;
                this.state = true;
            }
            finally {
                manager.cleanChunks(this.level.getSeed());
            }
        }
    }

    @Override
    public void onCompletion(Server server) {
        if (this.level != null) {
            if (!this.state) {
                return;
            }
            BaseFullChunk chunk = this.chunk;
            if (chunk == null) {
                return;
            }
            this.level.generateChunkCallback(chunk.getX(), chunk.getZ(), chunk);
        }
    }
}

