/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.particle;

import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.AddPlayerPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.PlayerListPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import cn.nukkit.utils.SerializedImage;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class FloatingTextParticle
extends Particle {
    private static final Skin EMPTY_SKIN = new Skin();
    private static final SerializedImage SKIN_DATA = SerializedImage.fromLegacy(new byte[8192]);
    protected UUID uuid = UUID.randomUUID();
    protected final Level level;
    protected long entityId = -1L;
    protected boolean invisible = false;
    protected EntityMetadata metadata = new EntityMetadata();

    public FloatingTextParticle(Location location, String title) {
        this(location, title, null);
    }

    public FloatingTextParticle(Location location, String title, String text) {
        this(location.getLevel(), location, title, text);
    }

    public FloatingTextParticle(Vector3 pos, String title) {
        this(pos, title, null);
    }

    public FloatingTextParticle(Vector3 pos, String title, String text) {
        this(null, pos, title, text);
    }

    private FloatingTextParticle(Level level, Vector3 pos, String title, String text) {
        super(pos.x, pos.y, pos.z);
        this.level = level;
        long flags = 65536L;
        this.metadata.putLong(0, flags).putLong(37, -1L).putFloat(38, 0.01f).putFloat(54, 0.01f).putFloat(53, 0.01f);
        if (!Strings.isNullOrEmpty(title)) {
            this.metadata.putString(4, title);
        }
        if (!Strings.isNullOrEmpty(text)) {
            this.metadata.putString(83, text);
        }
    }

    public String getText() {
        return this.metadata.getString(83);
    }

    public void setText(String text) {
        this.metadata.putString(83, text);
        this.sendMetadata();
    }

    public String getTitle() {
        return this.metadata.getString(4);
    }

    public void setTitle(String title) {
        this.metadata.putString(4, title);
        this.sendMetadata();
    }

    private void sendMetadata() {
        if (this.level != null) {
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.eid = this.entityId;
            packet.metadata = this.metadata;
            this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), packet);
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setInvisible() {
        this.setInvisible(true);
    }

    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public DataPacket[] encode() {
        ArrayList<DataPacket> packets = new ArrayList<DataPacket>();
        if (this.entityId == -1L) {
            this.entityId = 0xFF00000000L + ThreadLocalRandom.current().nextLong(0L, Integer.MAX_VALUE);
        } else {
            RemoveEntityPacket pk = new RemoveEntityPacket();
            pk.eid = this.entityId;
            packets.add(pk);
        }
        if (!this.invisible) {
            PlayerListPacket.Entry[] entry = new PlayerListPacket.Entry[]{new PlayerListPacket.Entry(this.uuid, this.entityId, this.metadata.getString(4), EMPTY_SKIN)};
            PlayerListPacket playerAdd = new PlayerListPacket();
            playerAdd.entries = entry;
            playerAdd.type = 0;
            packets.add(playerAdd);
            AddPlayerPacket pk = new AddPlayerPacket();
            pk.uuid = this.uuid;
            pk.username = "";
            pk.entityUniqueId = this.entityId;
            pk.entityRuntimeId = this.entityId;
            pk.x = (float)this.x;
            pk.y = (float)(this.y - 0.75);
            pk.z = (float)this.z;
            pk.speedX = 0.0f;
            pk.speedY = 0.0f;
            pk.speedZ = 0.0f;
            pk.yaw = 0.0f;
            pk.pitch = 0.0f;
            pk.metadata = this.metadata;
            pk.item = Item.get(0);
            packets.add(pk);
            PlayerListPacket playerRemove = new PlayerListPacket();
            playerRemove.entries = entry;
            playerRemove.type = 1;
            packets.add(playerRemove);
        }
        return packets.toArray(DataPacket.EMPTY_ARRAY);
    }

    static {
        EMPTY_SKIN.setSkinData(SKIN_DATA);
        EMPTY_SKIN.generateSkinId("FloatingText");
    }
}

