/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.BlockFace;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public enum CompassRoseDirection {
    NORTH(0, -1, BlockFace.NORTH),
    EAST(1, 0, BlockFace.EAST),
    SOUTH(0, 1, BlockFace.SOUTH),
    WEST(-1, 0, BlockFace.WEST),
    NORTH_EAST(NORTH, EAST, BlockFace.NORTH),
    NORTH_WEST(NORTH, WEST, BlockFace.WEST),
    SOUTH_EAST(SOUTH, EAST, BlockFace.EAST),
    SOUTH_WEST(SOUTH, WEST, BlockFace.SOUTH),
    WEST_NORTH_WEST(WEST, NORTH_WEST, BlockFace.WEST),
    NORTH_NORTH_WEST(NORTH, NORTH_WEST, BlockFace.NORTH),
    NORTH_NORTH_EAST(NORTH, NORTH_EAST, BlockFace.NORTH),
    EAST_NORTH_EAST(EAST, NORTH_EAST, BlockFace.EAST),
    EAST_SOUTH_EAST(EAST, SOUTH_EAST, BlockFace.EAST),
    SOUTH_SOUTH_EAST(SOUTH, SOUTH_EAST, BlockFace.SOUTH),
    SOUTH_SOUTH_WEST(SOUTH, SOUTH_WEST, BlockFace.SOUTH),
    WEST_SOUTH_WEST(WEST, SOUTH_WEST, BlockFace.WEST);

    private final int modX;
    private final int modZ;
    private final BlockFace closestBlockFace;

    private CompassRoseDirection(int modX, int modZ, BlockFace closestBlockFace) {
        this.modX = modX;
        this.modZ = modZ;
        this.closestBlockFace = closestBlockFace;
    }

    private CompassRoseDirection(CompassRoseDirection face1, CompassRoseDirection face2, BlockFace closestBlockFace) {
        this.modX = face1.getModX() + face2.getModX();
        this.modZ = face1.getModZ() + face2.getModZ();
        this.closestBlockFace = closestBlockFace;
    }

    public int getModX() {
        return this.modX;
    }

    public int getModZ() {
        return this.modZ;
    }

    public BlockFace getClosestBlockFace() {
        return this.closestBlockFace;
    }

    public CompassRoseDirection getOppositeFace() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return NORTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
            case NORTH_EAST: {
                return SOUTH_WEST;
            }
            case NORTH_WEST: {
                return SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return NORTH_WEST;
            }
            case SOUTH_WEST: {
                return NORTH_EAST;
            }
            case WEST_NORTH_WEST: {
                return EAST_SOUTH_EAST;
            }
            case NORTH_NORTH_WEST: {
                return SOUTH_SOUTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return SOUTH_SOUTH_WEST;
            }
            case EAST_NORTH_EAST: {
                return WEST_SOUTH_WEST;
            }
            case EAST_SOUTH_EAST: {
                return WEST_NORTH_WEST;
            }
            case SOUTH_SOUTH_EAST: {
                return NORTH_NORTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return NORTH_NORTH_EAST;
            }
            case WEST_SOUTH_WEST: {
                return EAST_NORTH_EAST;
            }
        }
        throw new IncompatibleClassChangeError("New values was added to the enum");
    }
}

