/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;

public abstract class VectorMath {
    public static Vector2 getDirection2D(double azimuth) {
        return new Vector2(Math.cos(azimuth), Math.sin(azimuth));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockFace.Axis calculateAxis(Vector3 base, Vector3 side) {
        Vector3 vector = side.subtract(base);
        return vector.x != 0.0 ? BlockFace.Axis.X : (vector.z != 0.0 ? BlockFace.Axis.Z : BlockFace.Axis.Y);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockFace calculateFace(Vector3 base, Vector3 side) {
        Vector3 vector = side.subtract(base);
        BlockFace.Axis axis = vector.x != 0.0 ? BlockFace.Axis.X : (vector.z != 0.0 ? BlockFace.Axis.Z : BlockFace.Axis.Y);
        double direction = vector.getAxis(axis);
        return BlockFace.fromAxis(direction < 0.0 ? BlockFace.AxisDirection.NEGATIVE : BlockFace.AxisDirection.POSITIVE, axis);
    }
}

