/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.metadata;

import cn.nukkit.block.Block;
import cn.nukkit.level.Level;
import cn.nukkit.metadata.MetadataStore;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.metadata.Metadatable;
import cn.nukkit.plugin.Plugin;
import java.util.List;

public class BlockMetadataStore
extends MetadataStore {
    private final Level owningLevel;

    public BlockMetadataStore(Level owningLevel) {
        this.owningLevel = owningLevel;
    }

    @Override
    protected String disambiguate(Metadatable block, String metadataKey) {
        if (!(block instanceof Block)) {
            throw new IllegalArgumentException("Argument must be a Block instance");
        }
        return ((Block)block).x + ":" + ((Block)block).y + ":" + ((Block)block).z + ":" + metadataKey;
    }

    @Override
    public List<MetadataValue> getMetadata(Object block, String metadataKey) {
        if (!(block instanceof Block)) {
            throw new IllegalArgumentException("Object must be a Block");
        }
        if (((Block)block).getLevel() == this.owningLevel) {
            return super.getMetadata(block, metadataKey);
        }
        throw new IllegalStateException("Block does not belong to world " + this.owningLevel.getName());
    }

    @Override
    public boolean hasMetadata(Object block, String metadataKey) {
        if (!(block instanceof Block)) {
            throw new IllegalArgumentException("Object must be a Block");
        }
        if (((Block)block).getLevel() == this.owningLevel) {
            return super.hasMetadata(block, metadataKey);
        }
        throw new IllegalStateException("Block does not belong to world " + this.owningLevel.getName());
    }

    @Override
    public void removeMetadata(Object block, String metadataKey, Plugin owningPlugin) {
        if (!(block instanceof Block)) {
            throw new IllegalArgumentException("Object must be a Block");
        }
        if (((Block)block).getLevel() != this.owningLevel) {
            throw new IllegalStateException("Block does not belong to world " + this.owningLevel.getName());
        }
        super.removeMetadata(block, metadataKey, owningPlugin);
    }

    @Override
    public void setMetadata(Object block, String metadataKey, MetadataValue newMetadataValue) {
        if (!(block instanceof Block)) {
            throw new IllegalArgumentException("Object must be a Block");
        }
        if (((Block)block).getLevel() != this.owningLevel) {
            throw new IllegalStateException("Block does not belong to world " + this.owningLevel.getName());
        }
        super.setMetadata(block, metadataKey, newMetadataValue);
    }
}

