/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.Nukkit;
import cn.nukkit.network.protocol.DataPacket;
import com.google.common.io.ByteStreams;
import java.io.InputStream;

public class AvailableEntityIdentifiersPacket
extends DataPacket {
    public static final byte NETWORK_ID = 119;
    private static final byte[] TAG;
    public byte[] tag = TAG;

    @Override
    public byte pid() {
        return 119;
    }

    @Override
    public void decode() {
        this.tag = this.get();
    }

    @Override
    public void encode() {
        this.reset();
        this.put(this.tag);
    }

    public String toString() {
        return "AvailableEntityIdentifiersPacket()";
    }

    static {
        try {
            InputStream inputStream = Nukkit.class.getClassLoader().getResourceAsStream("entity_identifiers.dat");
            if (inputStream == null) {
                throw new AssertionError((Object)"Could not find entity_identifiers.dat");
            }
            TAG = ByteStreams.toByteArray(inputStream);
        }
        catch (Exception e) {
            throw new AssertionError("Error whilst loading entity_identifiers.dat", e);
        }
    }
}

