/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.DataPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

@Since(value="1.4.0.0-PN")
public class ItemStackRequestPacket
extends DataPacket {
    @Since(value="1.4.0.0-PN")
    public final List<Request> requests = new ArrayList<Request>();

    @Override
    public byte pid() {
        return -109;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
    }

    public String toString() {
        return "ItemStackRequestPacket(requests=" + this.requests + ")";
    }

    @Since(value="1.4.0.0-PN")
    public static final class ItemStackAction {
        private final byte type;
        private final boolean bool0;
        private final byte byte0;
        private final int varInt0;
        private final int varInt1;
        private final byte baseByte0;
        private final byte baseByte1;
        private final byte baseByte2;
        private final int baseVarInt0;
        private final byte flagsByte0;
        private final byte flagsByte1;
        private final int flagsVarInt0;
        private final List<Item> items;

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            joiner.add("type=" + this.type);
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: {
                    joiner.add("baseByte0=" + this.baseByte0).add("baseByte1=" + this.baseByte1).add("baseByte2=" + this.baseByte2).add("baseVarInt0=" + this.baseVarInt0).add("flagsByte0=" + this.flagsByte0).add("flagsByte1=" + this.flagsByte1).add("flagsVarInt0=" + this.flagsVarInt0);
                    break;
                }
                case 3: {
                    joiner.add("bool0=" + this.bool0).add("baseByte0=" + this.baseByte0).add("baseByte1=" + this.baseByte1).add("baseByte2=" + this.baseByte2).add("baseVarInt0=" + this.baseVarInt0);
                    break;
                }
                case 4: 
                case 5: {
                    joiner.add("baseByte0=" + this.baseByte0).add("baseByte1=" + this.baseByte1).add("baseByte2=" + this.baseByte2).add("baseVarInt0=" + this.baseVarInt0);
                    break;
                }
                case 6: {
                    joiner.add("byte0=" + this.byte0);
                    break;
                }
                case 8: {
                    joiner.add("varInt0=" + this.varInt0).add("varInt1=" + this.varInt1);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    joiner.add("varInt0=" + this.varInt0);
                    break;
                }
                case 17: {
                    joiner.add("items=" + this.items);
                }
            }
            return "ItemStackAction(" + joiner.toString() + ")";
        }

        public ItemStackAction(byte type, boolean bool0, byte byte0, int varInt0, int varInt1, byte baseByte0, byte baseByte1, byte baseByte2, int baseVarInt0, byte flagsByte0, byte flagsByte1, int flagsVarInt0, List<Item> items) {
            this.type = type;
            this.bool0 = bool0;
            this.byte0 = byte0;
            this.varInt0 = varInt0;
            this.varInt1 = varInt1;
            this.baseByte0 = baseByte0;
            this.baseByte1 = baseByte1;
            this.baseByte2 = baseByte2;
            this.baseVarInt0 = baseVarInt0;
            this.flagsByte0 = flagsByte0;
            this.flagsByte1 = flagsByte1;
            this.flagsVarInt0 = flagsVarInt0;
            this.items = items;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isBool0() {
            return this.bool0;
        }

        public byte getByte0() {
            return this.byte0;
        }

        public int getVarInt0() {
            return this.varInt0;
        }

        public int getVarInt1() {
            return this.varInt1;
        }

        public byte getBaseByte0() {
            return this.baseByte0;
        }

        public byte getBaseByte1() {
            return this.baseByte1;
        }

        public byte getBaseByte2() {
            return this.baseByte2;
        }

        public int getBaseVarInt0() {
            return this.baseVarInt0;
        }

        public byte getFlagsByte0() {
            return this.flagsByte0;
        }

        public byte getFlagsByte1() {
            return this.flagsByte1;
        }

        public int getFlagsVarInt0() {
            return this.flagsVarInt0;
        }

        public List<Item> getItems() {
            return this.items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemStackAction)) {
                return false;
            }
            ItemStackAction other = (ItemStackAction)o;
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.isBool0() != other.isBool0()) {
                return false;
            }
            if (this.getByte0() != other.getByte0()) {
                return false;
            }
            if (this.getVarInt0() != other.getVarInt0()) {
                return false;
            }
            if (this.getVarInt1() != other.getVarInt1()) {
                return false;
            }
            if (this.getBaseByte0() != other.getBaseByte0()) {
                return false;
            }
            if (this.getBaseByte1() != other.getBaseByte1()) {
                return false;
            }
            if (this.getBaseByte2() != other.getBaseByte2()) {
                return false;
            }
            if (this.getBaseVarInt0() != other.getBaseVarInt0()) {
                return false;
            }
            if (this.getFlagsByte0() != other.getFlagsByte0()) {
                return false;
            }
            if (this.getFlagsByte1() != other.getFlagsByte1()) {
                return false;
            }
            if (this.getFlagsVarInt0() != other.getFlagsVarInt0()) {
                return false;
            }
            List<Item> this$items = this.getItems();
            List<Item> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + (this.isBool0() ? 79 : 97);
            result = result * 59 + this.getByte0();
            result = result * 59 + this.getVarInt0();
            result = result * 59 + this.getVarInt1();
            result = result * 59 + this.getBaseByte0();
            result = result * 59 + this.getBaseByte1();
            result = result * 59 + this.getBaseByte2();
            result = result * 59 + this.getBaseVarInt0();
            result = result * 59 + this.getFlagsByte0();
            result = result * 59 + this.getFlagsByte1();
            result = result * 59 + this.getFlagsVarInt0();
            List<Item> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }
    }

    @Since(value="1.4.0.0-PN")
    public static final class Request {
        private final int requestId;
        private final List<ItemStackAction> actions;

        public Request(int requestId, List<ItemStackAction> actions) {
            this.requestId = requestId;
            this.actions = actions;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public List<ItemStackAction> getActions() {
            return this.actions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            List<ItemStackAction> this$actions = this.getActions();
            List<ItemStackAction> other$actions = other.getActions();
            return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRequestId();
            List<ItemStackAction> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            return result;
        }

        public String toString() {
            return "ItemStackRequestPacket.Request(requestId=" + this.getRequestId() + ", actions=" + this.getActions() + ")";
        }
    }
}

