/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.level.GameRules;
import cn.nukkit.network.protocol.DataPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StartGamePacket
extends DataPacket {
    private static final Logger log = LogManager.getLogger(StartGamePacket.class);
    public static final byte NETWORK_ID = 11;
    public static final int GAME_PUBLISH_SETTING_NO_MULTI_PLAY = 0;
    public static final int GAME_PUBLISH_SETTING_INVITE_ONLY = 1;
    public static final int GAME_PUBLISH_SETTING_FRIENDS_ONLY = 2;
    public static final int GAME_PUBLISH_SETTING_FRIENDS_OF_FRIENDS = 3;
    public static final int GAME_PUBLISH_SETTING_PUBLIC = 4;
    public long entityUniqueId;
    public long entityRuntimeId;
    public int playerGamemode;
    public float x;
    public float y;
    public float z;
    public float yaw;
    public float pitch;
    public int seed;
    public byte dimension;
    public int generator = 1;
    public int worldGamemode;
    public int difficulty;
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    public boolean hasAchievementsDisabled = true;
    public int dayCycleStopTime = -1;
    public int eduEditionOffer = 0;
    public boolean hasEduFeaturesEnabled = false;
    public float rainLevel;
    public float lightningLevel;
    public boolean hasConfirmedPlatformLockedContent = false;
    public boolean multiplayerGame = true;
    public boolean broadcastToLAN = true;
    public int xblBroadcastIntent = 4;
    public int platformBroadcastIntent = 4;
    public boolean commandsEnabled;
    public boolean isTexturePacksRequired = false;
    public GameRules gameRules;
    public boolean bonusChest = false;
    public boolean hasStartWithMapEnabled = false;
    @Since(value="1.3.0.0-PN")
    public boolean trustingPlayers;
    public int permissionLevel = 1;
    public int serverChunkTickRange = 4;
    public boolean hasLockedBehaviorPack = false;
    public boolean hasLockedResourcePack = false;
    public boolean isFromLockedWorldTemplate = false;
    public boolean isUsingMsaGamertagsOnly = false;
    public boolean isFromWorldTemplate = false;
    public boolean isWorldTemplateOptionLocked = false;
    public boolean isOnlySpawningV1Villagers = false;
    public String vanillaVersion = "1.16.100";
    public String levelId = "";
    public String worldName;
    public String premiumWorldTemplateId = "";
    public boolean isTrial = false;
    public boolean isMovementServerAuthoritative;
    @Since(value="1.3.0.0-PN")
    public boolean isInventoryServerAuthoritative;
    public long currentTick;
    public int enchantmentSeed;
    public String multiplayerCorrelationId = "";

    @Override
    public byte pid() {
        return 11;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityUniqueId(this.entityUniqueId);
        this.putEntityRuntimeId(this.entityRuntimeId);
        this.putVarInt(this.playerGamemode);
        this.putVector3f(this.x, this.y, this.z);
        this.putLFloat(this.yaw);
        this.putLFloat(this.pitch);
        this.putVarInt(this.seed);
        this.putLShort(0);
        this.putString("plains");
        this.putVarInt(this.dimension);
        this.putVarInt(this.generator);
        this.putVarInt(this.worldGamemode);
        this.putVarInt(this.difficulty);
        this.putBlockVector3(this.spawnX, this.spawnY, this.spawnZ);
        this.putBoolean(this.hasAchievementsDisabled);
        this.putVarInt(this.dayCycleStopTime);
        this.putVarInt(this.eduEditionOffer);
        this.putBoolean(this.hasEduFeaturesEnabled);
        this.putString("");
        this.putLFloat(this.rainLevel);
        this.putLFloat(this.lightningLevel);
        this.putBoolean(this.hasConfirmedPlatformLockedContent);
        this.putBoolean(this.multiplayerGame);
        this.putBoolean(this.broadcastToLAN);
        this.putVarInt(this.xblBroadcastIntent);
        this.putVarInt(this.platformBroadcastIntent);
        this.putBoolean(this.commandsEnabled);
        this.putBoolean(this.isTexturePacksRequired);
        this.putGameRules(this.gameRules);
        this.putLInt(0);
        this.putBoolean(false);
        this.putBoolean(this.bonusChest);
        this.putBoolean(this.hasStartWithMapEnabled);
        this.putVarInt(this.permissionLevel);
        this.putLInt(this.serverChunkTickRange);
        this.putBoolean(this.hasLockedBehaviorPack);
        this.putBoolean(this.hasLockedResourcePack);
        this.putBoolean(this.isFromLockedWorldTemplate);
        this.putBoolean(this.isUsingMsaGamertagsOnly);
        this.putBoolean(this.isFromWorldTemplate);
        this.putBoolean(this.isWorldTemplateOptionLocked);
        this.putBoolean(this.isOnlySpawningV1Villagers);
        this.putString(this.vanillaVersion);
        this.putLInt(16);
        this.putLInt(16);
        this.putBoolean(false);
        this.putBoolean(false);
        this.putString(this.levelId);
        this.putString(this.worldName);
        this.putString(this.premiumWorldTemplateId);
        this.putBoolean(this.isTrial);
        this.putVarInt(this.isMovementServerAuthoritative ? 1 : 0);
        this.putLLong(this.currentTick);
        this.putVarInt(this.enchantmentSeed);
        this.putUnsignedVarInt(0L);
        this.put(RuntimeItems.ITEM_DATA_PALETTE);
        this.putString(this.multiplayerCorrelationId);
        this.putBoolean(this.isInventoryServerAuthoritative);
    }

    public String toString() {
        return "StartGamePacket(entityUniqueId=" + this.entityUniqueId + ", entityRuntimeId=" + this.entityRuntimeId + ", playerGamemode=" + this.playerGamemode + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", seed=" + this.seed + ", dimension=" + this.dimension + ", generator=" + this.generator + ", worldGamemode=" + this.worldGamemode + ", difficulty=" + this.difficulty + ", spawnX=" + this.spawnX + ", spawnY=" + this.spawnY + ", spawnZ=" + this.spawnZ + ", hasAchievementsDisabled=" + this.hasAchievementsDisabled + ", dayCycleStopTime=" + this.dayCycleStopTime + ", eduEditionOffer=" + this.eduEditionOffer + ", hasEduFeaturesEnabled=" + this.hasEduFeaturesEnabled + ", rainLevel=" + this.rainLevel + ", lightningLevel=" + this.lightningLevel + ", hasConfirmedPlatformLockedContent=" + this.hasConfirmedPlatformLockedContent + ", multiplayerGame=" + this.multiplayerGame + ", broadcastToLAN=" + this.broadcastToLAN + ", xblBroadcastIntent=" + this.xblBroadcastIntent + ", platformBroadcastIntent=" + this.platformBroadcastIntent + ", commandsEnabled=" + this.commandsEnabled + ", isTexturePacksRequired=" + this.isTexturePacksRequired + ", gameRules=" + this.gameRules + ", bonusChest=" + this.bonusChest + ", hasStartWithMapEnabled=" + this.hasStartWithMapEnabled + ", trustingPlayers=" + this.trustingPlayers + ", permissionLevel=" + this.permissionLevel + ", serverChunkTickRange=" + this.serverChunkTickRange + ", hasLockedBehaviorPack=" + this.hasLockedBehaviorPack + ", hasLockedResourcePack=" + this.hasLockedResourcePack + ", isFromLockedWorldTemplate=" + this.isFromLockedWorldTemplate + ", isUsingMsaGamertagsOnly=" + this.isUsingMsaGamertagsOnly + ", isFromWorldTemplate=" + this.isFromWorldTemplate + ", isWorldTemplateOptionLocked=" + this.isWorldTemplateOptionLocked + ", isOnlySpawningV1Villagers=" + this.isOnlySpawningV1Villagers + ", vanillaVersion=" + this.vanillaVersion + ", levelId=" + this.levelId + ", worldName=" + this.worldName + ", premiumWorldTemplateId=" + this.premiumWorldTemplateId + ", isTrial=" + this.isTrial + ", isMovementServerAuthoritative=" + this.isMovementServerAuthoritative + ", isInventoryServerAuthoritative=" + this.isInventoryServerAuthoritative + ", currentTick=" + this.currentTick + ", enchantmentSeed=" + this.enchantmentSeed + ", multiplayerCorrelationId=" + this.multiplayerCorrelationId + ")";
    }
}

