/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.BinaryStream;
import io.netty.util.internal.EmptyArrays;
import java.util.Arrays;

public class TextPacket
extends DataPacket {
    public static final byte NETWORK_ID = 9;
    public static final byte TYPE_RAW = 0;
    public static final byte TYPE_CHAT = 1;
    public static final byte TYPE_TRANSLATION = 2;
    public static final byte TYPE_POPUP = 3;
    public static final byte TYPE_JUKEBOX_POPUP = 4;
    public static final byte TYPE_TIP = 5;
    public static final byte TYPE_SYSTEM = 6;
    public static final byte TYPE_WHISPER = 7;
    public static final byte TYPE_ANNOUNCEMENT = 8;
    @Deprecated
    @PowerNukkitOnly(value="Backward compatibility")
    @DeprecationDetails(since="1.3.0.0-PN", toBeRemovedAt="1.4.0.0-PN", reason="Renamed to TYPE_JSON by NukkitX", replaceWith="TYPE_OBJECT")
    public static final byte TYPE_JSON = 9;
    @Since(value="1.3.0.0-PN")
    public static final byte TYPE_OBJECT = 9;
    @Since(value="1.3.0.0-PN")
    public static final byte TYPE_OBJECT_WHISPER = 10;
    public byte type;
    public String source = "";
    public String message = "";
    public String[] parameters = EmptyArrays.EMPTY_STRINGS;
    public boolean isLocalized = false;
    public String xboxUserId = "";
    public String platformChatId = "";

    @Override
    public byte pid() {
        return 9;
    }

    @Override
    public void decode() {
        this.type = (byte)this.getByte();
        this.isLocalized = this.getBoolean() || this.type == 2;
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: {
                this.source = this.getString();
            }
            case 0: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                this.message = this.getString();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.message = this.getString();
                this.parameters = this.getArray(String.class, BinaryStream::getString);
            }
        }
        this.xboxUserId = this.getString();
        this.platformChatId = this.getString();
    }

    @Override
    public void encode() {
        this.reset();
        this.putByte(this.type);
        this.putBoolean(this.isLocalized || this.type == 2);
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: {
                this.putString(this.source);
            }
            case 0: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                this.putString(this.message);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.putString(this.message);
                this.putUnsignedVarInt(this.parameters.length);
                for (String parameter : this.parameters) {
                    this.putString(parameter);
                }
                break;
            }
        }
        this.putString(this.xboxUserId);
        this.putString(this.platformChatId);
    }

    public String toString() {
        return "TextPacket(type=" + this.type + ", source=" + this.source + ", message=" + this.message + ", parameters=" + Arrays.deepToString(this.parameters) + ", isLocalized=" + this.isLocalized + ", xboxUserId=" + this.xboxUserId + ", platformChatId=" + this.platformChatId + ")";
    }
}

