/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.PluginCommand;
import cn.nukkit.command.PluginIdentifiableCommand;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginDescription;
import cn.nukkit.plugin.PluginLoader;
import cn.nukkit.plugin.PluginLogger;
import cn.nukkit.plugin.PowerNukkitPlugin;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.Utils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class PluginBase
implements Plugin {
    private PluginLoader loader;
    private Server server;
    private boolean isEnabled = false;
    private boolean initialized = false;
    private PluginDescription description;
    private File dataFolder;
    private Config config;
    private File configFile;
    private File file;
    private PluginLogger logger;

    @Override
    public void onLoad() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled() {
        this.setEnabled(true);
    }

    @PowerNukkitDifference(info="Made impossible to disable special the PowerNukkitPlugin", since="1.3.0.0-PN")
    public final void setEnabled(boolean value) {
        if (this.isEnabled != value) {
            if (!value && PowerNukkitPlugin.getInstance() == this) {
                throw new UnsupportedOperationException("The PowerNukkitPlugin cannot be disabled");
            }
            this.isEnabled = value;
            if (this.isEnabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
        }
    }

    @Override
    public final boolean isDisabled() {
        return !this.isEnabled;
    }

    @Override
    public final File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public final PluginDescription getDescription() {
        return this.description;
    }

    public final void init(PluginLoader loader, Server server, PluginDescription description, File dataFolder, File file) {
        if (!this.initialized) {
            this.initialized = true;
            this.loader = loader;
            this.server = server;
            this.description = description;
            this.dataFolder = dataFolder;
            this.file = file;
            this.configFile = new File(this.dataFolder, "config.yml");
            this.logger = new PluginLogger(this);
        }
    }

    @Override
    public PluginLogger getLogger() {
        return this.logger;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    public PluginIdentifiableCommand getCommand(String name) {
        PluginIdentifiableCommand command = this.getServer().getPluginCommand(name);
        if (command == null || !command.getPlugin().equals(this)) {
            command = this.getServer().getPluginCommand(this.description.getName().toLowerCase() + ":" + name);
        }
        if (command != null && command.getPlugin().equals(this)) {
            return command;
        }
        return null;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PluginCommand<?> getPluginCommand(@Nonnull String name) {
        PluginIdentifiableCommand command = this.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return false;
    }

    @Override
    public InputStream getResource(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream(filename);
    }

    @Override
    public boolean saveResource(String filename) {
        return this.saveResource(filename, false);
    }

    @Override
    public boolean saveResource(String filename, boolean replace) {
        return this.saveResource(filename, filename, replace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveResource(String filename, String outputName, boolean replace) {
        Preconditions.checkArgument(filename != null && outputName != null, "Filename can not be null!");
        Preconditions.checkArgument(filename.trim().length() != 0 && outputName.trim().length() != 0, "Filename can not be empty!");
        File out = new File(this.dataFolder, outputName);
        if (out.exists()) {
            if (!replace) return false;
        }
        try (InputStream resource = this.getResource(filename);){
            if (resource == null) return false;
            File outFolder = out.getParentFile();
            if (!outFolder.exists()) {
                outFolder.mkdirs();
            }
            Utils.writeFile(out, resource);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Server.getInstance().getLogger().logException(e);
        }
        return false;
    }

    @Override
    public Config getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    @Override
    public void saveConfig() {
        if (!this.getConfig().save()) {
            this.getLogger().critical("Could not save config to " + this.configFile.toString());
        }
    }

    @Override
    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.saveResource("config.yml", false);
        }
    }

    @Override
    public void reloadConfig() {
        this.config = new Config(this.configFile);
        InputStream configStream = this.getResource("config.yml");
        if (configStream != null) {
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(dumperOptions);
            try {
                this.config.setDefault(yaml.loadAs(Utils.readFile(this.configFile), LinkedHashMap.class));
            }
            catch (IOException e) {
                Server.getInstance().getLogger().logException(e);
            }
        }
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getName() {
        return this.description.getName();
    }

    public final String getFullName() {
        return this.description.getFullName();
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public PluginLoader getPluginLoader() {
        return this.loader;
    }
}

