/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.positiontracking;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.positiontracking.NamedPosition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class PositionTracking
extends NamedPosition {
    @Nonnull
    private String levelName;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull String levelName, double x, double y, double z) {
        super(x, y, z);
        this.levelName = levelName;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull Level level, double x, double y, double z) {
        this(level.getName(), x, y, z);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull Level level, Vector3 v) {
        this(level, v.x, v.y, v.z);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull String levelName, Vector3 v) {
        this(levelName, v.x, v.y, v.z);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull Position pos) {
        this(pos.getLevel(), pos.x, pos.y, pos.z);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public PositionTracking(@Nonnull NamedPosition pos) {
        this(pos.getLevelName(), pos.x, pos.y, pos.z);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getLevelName() {
        return this.levelName;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setLevelName(@Nonnull String levelName) {
        this.levelName = levelName;
    }

    @Override
    @Nonnull
    public PositionTracking add(double x) {
        return this.add(x, 0.0, 0.0);
    }

    @Override
    public PositionTracking add(double x, double y) {
        return this.add(x, y, 0.0);
    }

    @Override
    public PositionTracking add(double x, double y, double z) {
        return new PositionTracking(this.levelName, this.x + x, this.y + y, this.z + z);
    }

    @Override
    public PositionTracking add(Vector3 v) {
        return new PositionTracking(this.levelName, this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @Override
    public PositionTracking subtract() {
        return new PositionTracking(this.levelName, this.x, this.y, this.z);
    }

    @Override
    public PositionTracking subtract(double x) {
        return this.subtract(x, 0.0, 0.0);
    }

    @Override
    public PositionTracking subtract(double x, double y) {
        return this.subtract(x, y, 0.0);
    }

    @Override
    public PositionTracking subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    @Override
    public PositionTracking subtract(Vector3 v) {
        return this.add(-v.x, -v.y, -v.z);
    }

    @Override
    public PositionTracking multiply(double number) {
        return new PositionTracking(this.levelName, this.x * number, this.y * number, this.z * number);
    }

    @Override
    public PositionTracking divide(double number) {
        return new PositionTracking(this.levelName, this.x * number, this.y * number, this.z * number);
    }

    @Override
    public PositionTracking ceil() {
        return new PositionTracking(this.levelName, Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    @Override
    public PositionTracking floor() {
        return new PositionTracking(this.levelName, Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    @Override
    public PositionTracking round() {
        return new PositionTracking(this.levelName, (double)Math.round(this.x), (double)Math.round(this.y), (double)Math.round(this.z));
    }

    @Override
    public PositionTracking abs() {
        return new PositionTracking(this.levelName, Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    @Override
    public PositionTracking getSide(BlockFace face) {
        return this.getSide(face, 1);
    }

    @Override
    public PositionTracking getSide(BlockFace face, int step) {
        return new PositionTracking(this.levelName, this.x + (double)(face.getXOffset() * step), this.y + (double)(face.getYOffset() * step), this.z + (double)(face.getZOffset() * step));
    }

    @Override
    public PositionTracking up() {
        return this.up(1);
    }

    @Override
    public PositionTracking up(int step) {
        return this.getSide(BlockFace.UP, step);
    }

    @Override
    public PositionTracking down() {
        return this.down(1);
    }

    @Override
    public PositionTracking down(int step) {
        return this.getSide(BlockFace.DOWN, step);
    }

    @Override
    public PositionTracking north() {
        return this.north(1);
    }

    @Override
    public PositionTracking north(int step) {
        return this.getSide(BlockFace.NORTH, step);
    }

    @Override
    public PositionTracking south() {
        return this.south(1);
    }

    @Override
    public PositionTracking south(int step) {
        return this.getSide(BlockFace.SOUTH, step);
    }

    @Override
    public PositionTracking east() {
        return this.east(1);
    }

    @Override
    public PositionTracking east(int step) {
        return this.getSide(BlockFace.EAST, step);
    }

    @Override
    public PositionTracking west() {
        return this.west(1);
    }

    @Override
    public PositionTracking west(int step) {
        return this.getSide(BlockFace.WEST, step);
    }

    @Override
    @Nullable
    public PositionTracking getIntermediateWithXValue(@Nonnull Vector3 v, double x) {
        Vector3 intermediateWithXValue = super.getIntermediateWithXValue(v, x);
        if (intermediateWithXValue == null) {
            return null;
        }
        return new PositionTracking(this.levelName, intermediateWithXValue);
    }

    @Override
    @Nullable
    public Vector3 getIntermediateWithYValue(@Nonnull Vector3 v, double y) {
        Vector3 intermediateWithYValue = super.getIntermediateWithYValue(v, y);
        if (intermediateWithYValue == null) {
            return null;
        }
        return new PositionTracking(this.levelName, intermediateWithYValue);
    }

    @Override
    @Nullable
    public Vector3 getIntermediateWithZValue(@Nonnull Vector3 v, double z) {
        Vector3 intermediateWithZValue = super.getIntermediateWithZValue(v, z);
        if (intermediateWithZValue == null) {
            return null;
        }
        return new PositionTracking(this.levelName, intermediateWithZValue);
    }

    @Override
    @Nullable
    public PositionTracking setComponents(double x, double y, double z) {
        super.setComponents(x, y, z);
        return this;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public PositionTracking setComponents(Vector3 pos) {
        super.setComponents(pos);
        return this;
    }

    @Override
    public PositionTracking clone() {
        return (PositionTracking)super.clone();
    }
}

