/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.EntityData;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.data.IntPositionEntityData;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.data.NBTEntityData;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.entity.data.Vector3fEntityData;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BinaryStream;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

public class Binary {
    public static int signByte(int value) {
        return value << 56 >> 56;
    }

    public static int unsignByte(int value) {
        return value & 0xFF;
    }

    public static int signShort(int value) {
        return value << 48 >> 48;
    }

    public int unsignShort(int value) {
        return value & 0xFFFF;
    }

    public static int signInt(int value) {
        return value << 32 >> 32;
    }

    public static int unsignInt(int value) {
        return value;
    }

    public static int readTriad(byte[] bytes) {
        return Binary.readInt(new byte[]{0, bytes[0], bytes[1], bytes[2]});
    }

    public static byte[] writeTriad(int value) {
        return new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static int readLTriad(byte[] bytes) {
        return Binary.readLInt(new byte[]{bytes[0], bytes[1], bytes[2], 0});
    }

    public static byte[] writeLTriad(int value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF)};
    }

    public static UUID readUUID(byte[] bytes) {
        return new UUID(Binary.readLLong(bytes), Binary.readLLong(new byte[]{bytes[8], bytes[9], bytes[10], bytes[11], bytes[12], bytes[13], bytes[14], bytes[15]}));
    }

    public static byte[] writeUUID(UUID uuid) {
        return Binary.appendBytes(Binary.writeLLong(uuid.getMostSignificantBits()), (byte[][])new byte[][]{Binary.writeLLong(uuid.getLeastSignificantBits())});
    }

    public static byte[] writeMetadata(EntityMetadata metadata) {
        BinaryStream stream = new BinaryStream();
        Map<Integer, EntityData> map = metadata.getMap();
        stream.putUnsignedVarInt(map.size());
        for (int id : map.keySet()) {
            EntityData d = map.get(id);
            stream.putUnsignedVarInt(id);
            stream.putUnsignedVarInt(d.getType());
            switch (d.getType()) {
                case 0: {
                    stream.putByte(((ByteEntityData)d).getData().byteValue());
                    break;
                }
                case 1: {
                    stream.putLShort(((ShortEntityData)d).getData());
                    break;
                }
                case 2: {
                    stream.putVarInt(((IntEntityData)d).getData());
                    break;
                }
                case 3: {
                    stream.putLFloat(((FloatEntityData)d).getData().floatValue());
                    break;
                }
                case 4: {
                    String s = ((StringEntityData)d).getData();
                    stream.putUnsignedVarInt(s.getBytes(StandardCharsets.UTF_8).length);
                    stream.put(s.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 5: {
                    NBTEntityData slot = (NBTEntityData)d;
                    try {
                        stream.put(NBTIO.write(slot.getData(), ByteOrder.LITTLE_ENDIAN, true));
                        break;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case 6: {
                    IntPositionEntityData pos = (IntPositionEntityData)d;
                    stream.putVarInt(pos.x);
                    stream.putVarInt(pos.y);
                    stream.putVarInt(pos.z);
                    break;
                }
                case 7: {
                    stream.putVarLong(((LongEntityData)d).getData());
                    break;
                }
                case 8: {
                    Vector3fEntityData v3data = (Vector3fEntityData)d;
                    stream.putLFloat(v3data.x);
                    stream.putLFloat(v3data.y);
                    stream.putLFloat(v3data.z);
                }
            }
        }
        return stream.getBuffer();
    }

    public static EntityMetadata readMetadata(byte[] payload) {
        BinaryStream stream = new BinaryStream();
        stream.setBuffer(payload);
        long count = stream.getUnsignedVarInt();
        EntityMetadata m = new EntityMetadata();
        int i = 0;
        while ((long)i < count) {
            int key = (int)stream.getUnsignedVarInt();
            int type = (int)stream.getUnsignedVarInt();
            EntityData value = null;
            switch (type) {
                case 0: {
                    value = new ByteEntityData(key, stream.getByte());
                    break;
                }
                case 1: {
                    value = new ShortEntityData(key, stream.getLShort());
                    break;
                }
                case 2: {
                    value = new IntEntityData(key, stream.getVarInt());
                    break;
                }
                case 3: {
                    value = new FloatEntityData(key, stream.getLFloat());
                    break;
                }
                case 4: {
                    value = new StringEntityData(key, stream.getString());
                    break;
                }
                case 5: {
                    int offset = stream.getOffset();
                    FastByteArrayInputStream fbais = new FastByteArrayInputStream(stream.get());
                    try {
                        CompoundTag tag = NBTIO.read(fbais, ByteOrder.LITTLE_ENDIAN, true);
                        value = new NBTEntityData(key, tag);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    stream.setOffset(offset + (int)fbais.position());
                    break;
                }
                case 6: {
                    BlockVector3 v3 = stream.getSignedBlockPosition();
                    value = new IntPositionEntityData(key, v3.x, v3.y, v3.z);
                    break;
                }
                case 7: {
                    value = new LongEntityData(key, stream.getVarLong());
                    break;
                }
                case 8: {
                    value = new Vector3fEntityData(key, stream.getVector3f());
                }
            }
            if (value != null) {
                m.put(value);
            }
            ++i;
        }
        return m;
    }

    public static boolean readBool(byte b) {
        return b == 0;
    }

    public static byte writeBool(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    public static int readSignedByte(byte b) {
        return b & 0xFF;
    }

    public static byte writeByte(byte b) {
        return b;
    }

    public static int readShort(byte[] bytes) {
        return ((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF);
    }

    public static short readSignedShort(byte[] bytes) {
        return (short)Binary.readShort(bytes);
    }

    public static byte[] writeShort(int s) {
        return new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
    }

    public static int readLShort(byte[] bytes) {
        return ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
    }

    public static short readSignedLShort(byte[] bytes) {
        return (short)Binary.readLShort(bytes);
    }

    public static byte[] writeLShort(int s) {
        return new byte[]{(byte)((s &= 0xFFFF) & 0xFF), (byte)(s >>> 8 & 0xFF)};
    }

    public static int readInt(byte[] bytes) {
        return ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
    }

    public static byte[] writeInt(int i) {
        return new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    public static int readLInt(byte[] bytes) {
        return ((bytes[3] & 0xFF) << 24) + ((bytes[2] & 0xFF) << 16) + ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
    }

    public static byte[] writeLInt(int i) {
        return new byte[]{(byte)(i & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 24 & 0xFF)};
    }

    public static float readFloat(byte[] bytes) {
        return Binary.readFloat(bytes, -1);
    }

    public static float readFloat(byte[] bytes, int accuracy) {
        float val = Float.intBitsToFloat(Binary.readInt(bytes));
        if (accuracy > -1) {
            return (float)NukkitMath.round(val, accuracy);
        }
        return val;
    }

    public static byte[] writeFloat(float f) {
        return Binary.writeInt(Float.floatToIntBits(f));
    }

    public static float readLFloat(byte[] bytes) {
        return Binary.readLFloat(bytes, -1);
    }

    public static float readLFloat(byte[] bytes, int accuracy) {
        float val = Float.intBitsToFloat(Binary.readLInt(bytes));
        if (accuracy > -1) {
            return (float)NukkitMath.round(val, accuracy);
        }
        return val;
    }

    public static byte[] writeLFloat(float f) {
        return Binary.writeLInt(Float.floatToIntBits(f));
    }

    public static double readDouble(byte[] bytes) {
        return Double.longBitsToDouble(Binary.readLong(bytes));
    }

    public static byte[] writeDouble(double d) {
        return Binary.writeLong(Double.doubleToLongBits(d));
    }

    public static double readLDouble(byte[] bytes) {
        return Double.longBitsToDouble(Binary.readLLong(bytes));
    }

    public static byte[] writeLDouble(double d) {
        return Binary.writeLLong(Double.doubleToLongBits(d));
    }

    public static long readLong(byte[] bytes) {
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)(bytes[7] & 0xFF);
    }

    public static byte[] writeLong(long l) {
        return new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
    }

    public static long readLLong(byte[] bytes) {
        return ((long)bytes[7] << 56) + ((long)(bytes[6] & 0xFF) << 48) + ((long)(bytes[5] & 0xFF) << 40) + ((long)(bytes[4] & 0xFF) << 32) + ((long)(bytes[3] & 0xFF) << 24) + (long)((bytes[2] & 0xFF) << 16) + (long)((bytes[1] & 0xFF) << 8) + (long)(bytes[0] & 0xFF);
    }

    public static byte[] writeLLong(long l) {
        return new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)};
    }

    public static byte[] writeVarInt(int v) {
        BinaryStream stream = new BinaryStream();
        stream.putVarInt(v);
        return stream.getBuffer();
    }

    public static byte[] writeUnsignedVarInt(long v) {
        BinaryStream stream = new BinaryStream();
        stream.putUnsignedVarInt(v);
        return stream.getBuffer();
    }

    public static byte[] reserveBytes(byte[] bytes) {
        byte[] newBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            newBytes[bytes.length - 1 - i] = bytes[i];
        }
        return newBytes;
    }

    public static String bytesToHexString(byte[] src) {
        return Binary.bytesToHexString(src, false);
    }

    public static String bytesToHexString(byte[] src, boolean blank) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte b : src) {
            int v;
            String hv;
            if (stringBuilder.length() != 0 && blank) {
                stringBuilder.append(" ");
            }
            if ((hv = Integer.toHexString(v = b & 0xFF)).length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        String str = "0123456789ABCDEF";
        hexString = hexString.toUpperCase().replace(" ", "");
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)((byte)str.indexOf(hexChars[pos]) << 4 | (byte)str.indexOf(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte[] subBytes(byte[] bytes, int start, int length) {
        int len = Math.min(bytes.length, start + length);
        return Arrays.copyOfRange(bytes, start, len);
    }

    public static byte[] subBytes(byte[] bytes, int start) {
        return Binary.subBytes(bytes, start, bytes.length - start);
    }

    public static byte[][] splitBytes(byte[] bytes, int chunkSize) {
        byte[][] splits = new byte[(bytes.length + chunkSize - 1) / chunkSize][chunkSize];
        int chunks = 0;
        for (int i = 0; i < bytes.length; i += chunkSize) {
            splits[chunks] = bytes.length - i > chunkSize ? Arrays.copyOfRange(bytes, i, i + chunkSize) : Arrays.copyOfRange(bytes, i, bytes.length);
            ++chunks;
        }
        return splits;
    }

    public static byte[] appendBytes(byte[][] bytes) {
        int length = 0;
        for (byte[] b : bytes) {
            length += b.length;
        }
        byte[] appendedBytes = new byte[length];
        int index = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, appendedBytes, index, b.length);
            index += b.length;
        }
        return appendedBytes;
    }

    public static byte[] appendBytes(byte byte1, byte[] ... bytes2) {
        int length = 1;
        for (byte[] bytes : bytes2) {
            length += bytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(byte1);
        for (byte[] bytes : bytes2) {
            buffer.put(bytes);
        }
        return buffer.array();
    }

    public static byte[] appendBytes(byte[] bytes1, byte[] ... bytes2) {
        int length = bytes1.length;
        for (byte[] bytes : bytes2) {
            length += bytes.length;
        }
        byte[] appendedBytes = new byte[length];
        System.arraycopy(bytes1, 0, appendedBytes, 0, bytes1.length);
        int index = bytes1.length;
        for (byte[] b : bytes2) {
            System.arraycopy(b, 0, appendedBytes, index, b.length);
            index += b.length;
        }
        return appendedBytes;
    }
}

