/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.LoginChainData;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minidev.json.JSONObject;

public final class ClientChainData
implements LoginChainData {
    private static final String MOJANG_PUBLIC_KEY_BASE64 = "MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAE8ELkixyLcwlZryUQcu1TvPOmI2B7vX83ndnWRUaXm74wFfa5f/lwQNTfrLVHa2PmenpGI6JhIMUJaWZrjmMj90NoKNFSNBuKdm8rYiXsfaz3K36x/1U26HpG0ZxK/V1V";
    private static final PublicKey MOJANG_PUBLIC_KEY;
    private boolean xboxAuthed;
    public static final int UI_PROFILE_CLASSIC = 0;
    public static final int UI_PROFILE_POCKET = 1;
    private String username;
    private UUID clientUUID;
    private String xuid;
    private String identityPublicKey;
    private long clientId;
    private String serverAddress;
    private String deviceModel;
    private int deviceOS;
    private String deviceId;
    private String gameVersion;
    private int guiScale;
    private String languageCode;
    private int currentInputMode;
    private int defaultInputMode;
    private int UIProfile;
    private String capeData;
    private JsonObject rawData;
    private BinaryStream bs = new BinaryStream();

    public static ClientChainData of(byte[] buffer) {
        return new ClientChainData(buffer);
    }

    public static ClientChainData read(LoginPacket pk) {
        return ClientChainData.of(pk.getBuffer());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getClientUUID() {
        return this.clientUUID;
    }

    @Override
    public String getIdentityPublicKey() {
        return this.identityPublicKey;
    }

    @Override
    public long getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public int getDeviceOS() {
        return this.deviceOS;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Override
    public int getGuiScale() {
        return this.guiScale;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public String getXUID() {
        return this.xuid;
    }

    @Override
    public int getCurrentInputMode() {
        return this.currentInputMode;
    }

    @Override
    public int getDefaultInputMode() {
        return this.defaultInputMode;
    }

    @Override
    public String getCapeData() {
        return this.capeData;
    }

    @Override
    public int getUIProfile() {
        return this.UIProfile;
    }

    @Override
    public JsonObject getRawData() {
        return this.rawData;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientChainData && Objects.equals(this.bs, ((ClientChainData)obj).bs);
    }

    public int hashCode() {
        return this.bs.hashCode();
    }

    private static PublicKey generateKey(String base64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(base64)));
    }

    private ClientChainData(byte[] buffer) {
        this.bs.setBuffer(buffer, 0);
        this.decodeChainData();
        this.decodeSkinData();
    }

    @Override
    public boolean isXboxAuthed() {
        return this.xboxAuthed;
    }

    private void decodeSkinData() {
        JsonObject skinToken = this.decodeToken(new String(this.bs.get(this.bs.getLInt())));
        if (skinToken == null) {
            return;
        }
        if (skinToken.has("ClientRandomId")) {
            this.clientId = skinToken.get("ClientRandomId").getAsLong();
        }
        if (skinToken.has("ServerAddress")) {
            this.serverAddress = skinToken.get("ServerAddress").getAsString();
        }
        if (skinToken.has("DeviceModel")) {
            this.deviceModel = skinToken.get("DeviceModel").getAsString();
        }
        if (skinToken.has("DeviceOS")) {
            this.deviceOS = skinToken.get("DeviceOS").getAsInt();
        }
        if (skinToken.has("DeviceId")) {
            this.deviceId = skinToken.get("DeviceId").getAsString();
        }
        if (skinToken.has("GameVersion")) {
            this.gameVersion = skinToken.get("GameVersion").getAsString();
        }
        if (skinToken.has("GuiScale")) {
            this.guiScale = skinToken.get("GuiScale").getAsInt();
        }
        if (skinToken.has("LanguageCode")) {
            this.languageCode = skinToken.get("LanguageCode").getAsString();
        }
        if (skinToken.has("CurrentInputMode")) {
            this.currentInputMode = skinToken.get("CurrentInputMode").getAsInt();
        }
        if (skinToken.has("DefaultInputMode")) {
            this.defaultInputMode = skinToken.get("DefaultInputMode").getAsInt();
        }
        if (skinToken.has("UIProfile")) {
            this.UIProfile = skinToken.get("UIProfile").getAsInt();
        }
        if (skinToken.has("CapeData")) {
            this.capeData = skinToken.get("CapeData").getAsString();
        }
        this.rawData = skinToken;
    }

    private JsonObject decodeToken(String token) {
        String[] base = token.split("\\.");
        if (base.length < 2) {
            return null;
        }
        String json = new String(Base64.getDecoder().decode(base[1]), StandardCharsets.UTF_8);
        return new Gson().fromJson(json, JsonObject.class);
    }

    private void decodeChainData() {
        Map map = (Map)new Gson().fromJson(new String(this.bs.get(this.bs.getLInt()), StandardCharsets.UTF_8), new TypeToken<Map<String, List<String>>>(){}.getType());
        if (map.isEmpty() || !map.containsKey("chain") || ((List)map.get("chain")).isEmpty()) {
            return;
        }
        List chains = (List)map.get("chain");
        try {
            this.xboxAuthed = this.verifyChain(chains);
        }
        catch (Exception e) {
            this.xboxAuthed = false;
        }
        for (String c : chains) {
            JsonObject chainMap = this.decodeToken(c);
            if (chainMap == null) continue;
            if (chainMap.has("extraData")) {
                JsonObject extra = chainMap.get("extraData").getAsJsonObject();
                if (extra.has("displayName")) {
                    this.username = extra.get("displayName").getAsString();
                }
                if (extra.has("identity")) {
                    this.clientUUID = UUID.fromString(extra.get("identity").getAsString());
                }
                if (extra.has("XUID")) {
                    this.xuid = extra.get("XUID").getAsString();
                }
            }
            if (!chainMap.has("identityPublicKey")) continue;
            this.identityPublicKey = chainMap.get("identityPublicKey").getAsString();
        }
        if (!this.xboxAuthed) {
            this.xuid = null;
        }
    }

    private boolean verifyChain(List<String> chains) throws Exception {
        PublicKey lastKey = null;
        boolean mojangKeyVerified = false;
        for (String chain : chains) {
            JWSObject jws = JWSObject.parse(chain);
            if (!mojangKeyVerified) {
                mojangKeyVerified = this.verify(MOJANG_PUBLIC_KEY, jws);
            }
            if (lastKey != null && !this.verify(lastKey, jws)) {
                throw new JOSEException("Unable to verify key in chain.");
            }
            JSONObject payload = jws.getPayload().toJSONObject();
            String base64key = payload.getAsString("identityPublicKey");
            if (base64key == null) {
                throw new RuntimeException("No key found");
            }
            lastKey = ClientChainData.generateKey(base64key);
        }
        return mojangKeyVerified;
    }

    private boolean verify(PublicKey key, JWSObject object) throws JOSEException {
        JWSVerifier verifier = new DefaultJWSVerifierFactory().createJWSVerifier(object.getHeader(), key);
        return object.verify(verifier);
    }

    static {
        try {
            MOJANG_PUBLIC_KEY = ClientChainData.generateKey(MOJANG_PUBLIC_KEY_BASE64);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AssertionError((Object)e);
        }
    }
}

