/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Player;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.BossEventPacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import cn.nukkit.network.protocol.UpdateAttributesPacket;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class DummyBossBar {
    private final Player player;
    private final long bossBarId;
    private String text;
    private float length;
    private BlockColor color;

    private DummyBossBar(Builder builder) {
        this.player = builder.player;
        this.bossBarId = builder.bossBarId;
        this.text = builder.text;
        this.length = builder.length;
        this.color = builder.color;
    }

    public Player getPlayer() {
        return this.player;
    }

    public long getBossBarId() {
        return this.bossBarId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            this.updateBossEntityNameTag();
            this.sendSetBossBarTitle();
        }
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        if (this.length != length) {
            this.length = length;
            this.sendAttributes();
            this.sendSetBossBarLength();
        }
    }

    public void setColor(BlockColor color) {
        if (this.color == null || !this.color.equals(color)) {
            this.color = color;
            this.sendSetBossBarTexture();
        }
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(new BlockColor(red, green, blue));
    }

    public int getMixedColor() {
        return this.color.getRGB();
    }

    public BlockColor getColor() {
        return this.color;
    }

    private void createBossEntity() {
        AddEntityPacket pkAdd = new AddEntityPacket();
        pkAdd.type = 33;
        pkAdd.entityUniqueId = this.bossBarId;
        pkAdd.entityRuntimeId = this.bossBarId;
        pkAdd.x = (float)this.player.x;
        pkAdd.y = -10.0f;
        pkAdd.z = (float)this.player.z;
        pkAdd.speedX = 0.0f;
        pkAdd.speedY = 0.0f;
        pkAdd.speedZ = 0.0f;
        pkAdd.metadata = new EntityMetadata().putLong(0, 0L).putShort(7, 400).putShort(42, 400).putLong(37, -1L).putString(4, this.text).putFloat(38, 0.0f);
        this.player.dataPacket(pkAdd);
    }

    private void sendAttributes() {
        UpdateAttributesPacket pkAttributes = new UpdateAttributesPacket();
        pkAttributes.entityId = this.bossBarId;
        Attribute attr = Attribute.getAttribute(4);
        attr.setMaxValue(100.0f);
        attr.setValue(this.length);
        pkAttributes.entries = new Attribute[]{attr};
        this.player.dataPacket(pkAttributes);
    }

    private void sendShowBossBar() {
        BossEventPacket pkBoss = new BossEventPacket();
        pkBoss.bossEid = this.bossBarId;
        pkBoss.type = 0;
        pkBoss.title = this.text;
        pkBoss.healthPercent = this.length / 100.0f;
        this.player.dataPacket(pkBoss);
    }

    private void sendHideBossBar() {
        BossEventPacket pkBoss = new BossEventPacket();
        pkBoss.bossEid = this.bossBarId;
        pkBoss.type = 2;
        this.player.dataPacket(pkBoss);
    }

    private void sendSetBossBarTexture() {
        BossEventPacket pk = new BossEventPacket();
        pk.bossEid = this.bossBarId;
        pk.type = 7;
        pk.color = this.getMixedColor();
        this.player.dataPacket(pk);
    }

    private void sendSetBossBarTitle() {
        BossEventPacket pkBoss = new BossEventPacket();
        pkBoss.bossEid = this.bossBarId;
        pkBoss.type = 5;
        pkBoss.title = this.text;
        pkBoss.healthPercent = this.length / 100.0f;
        this.player.dataPacket(pkBoss);
    }

    private void sendSetBossBarLength() {
        BossEventPacket pkBoss = new BossEventPacket();
        pkBoss.bossEid = this.bossBarId;
        pkBoss.type = 4;
        pkBoss.healthPercent = this.length / 100.0f;
        this.player.dataPacket(pkBoss);
    }

    public void updateBossEntityPosition() {
        MoveEntityAbsolutePacket pk = new MoveEntityAbsolutePacket();
        pk.eid = this.bossBarId;
        pk.x = this.player.x;
        pk.y = -10.0;
        pk.z = this.player.z;
        pk.headYaw = 0.0;
        pk.yaw = 0.0;
        pk.pitch = 0.0;
        this.player.dataPacket(pk);
    }

    private void updateBossEntityNameTag() {
        SetEntityDataPacket pk = new SetEntityDataPacket();
        pk.eid = this.bossBarId;
        pk.metadata = new EntityMetadata().putString(4, this.text);
        this.player.dataPacket(pk);
    }

    private void removeBossEntity() {
        RemoveEntityPacket pkRemove = new RemoveEntityPacket();
        pkRemove.eid = this.bossBarId;
        this.player.dataPacket(pkRemove);
    }

    public void create() {
        this.createBossEntity();
        this.sendAttributes();
        this.sendShowBossBar();
        this.sendSetBossBarLength();
        if (this.color != null) {
            this.sendSetBossBarTexture();
        }
    }

    public void reshow() {
        this.updateBossEntityPosition();
        this.sendShowBossBar();
        this.sendSetBossBarLength();
    }

    public void destroy() {
        this.sendHideBossBar();
        this.removeBossEntity();
    }

    public static class Builder {
        private final Player player;
        private final long bossBarId;
        private String text = "";
        private float length = 100.0f;
        private BlockColor color = null;

        public Builder(Player player) {
            this.player = player;
            this.bossBarId = 0xFF00000000L + ThreadLocalRandom.current().nextLong(0L, Integer.MAX_VALUE);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder length(float length) {
            if (length >= 0.0f && length <= 100.0f) {
                this.length = length;
            }
            return this;
        }

        public Builder color(BlockColor color) {
            this.color = color;
            return this;
        }

        public Builder color(int red, int green, int blue) {
            return this.color(new BlockColor(red, green, blue));
        }

        public DummyBossBar build() {
            return new DummyBossBar(this);
        }
    }
}

