/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import java.util.HashMap;
import java.util.Map;

public enum MinecartType {
    MINECART_EMPTY(0, false, "Minecart"),
    MINECART_CHEST(1, true, "Minecart with Chest"),
    MINECART_FURNACE(2, true, "Minecart with Furnace"),
    MINECART_TNT(3, true, "Minecart with TNT"),
    MINECART_MOB_SPAWNER(4, true, "Minecart with Mob Spawner"),
    MINECART_HOPPER(5, true, "Minecart with Hopper"),
    MINECART_COMMAND_BLOCK(6, true, "Minecart with Command Block"),
    MINECART_UNKNOWN(-1, false, "Unknown Minecart");

    private final int type;
    private final boolean hasBlockInside;
    private final String realName;
    private static final Map<Integer, MinecartType> TYPES;

    private MinecartType(int number, boolean hasBlockInside, String name) {
        this.type = number;
        this.hasBlockInside = hasBlockInside;
        this.realName = name;
    }

    public int getId() {
        return this.type;
    }

    public String getName() {
        return this.realName;
    }

    public boolean hasBlockInside() {
        return this.hasBlockInside;
    }

    public static MinecartType valueOf(int types) {
        MinecartType what = TYPES.get(types);
        return what == null ? MINECART_UNKNOWN : what;
    }

    static {
        TYPES = new HashMap<Integer, MinecartType>();
        for (MinecartType var3 : MinecartType.values()) {
            TYPES.put(var3.getId(), var3);
        }
    }
}

