/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.utils.functional.BooleanConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public enum OptionalBoolean {
    TRUE(Boolean.TRUE),
    FALSE(Boolean.FALSE),
    EMPTY(null);

    @Nullable
    private final Boolean value;

    private OptionalBoolean(Boolean value) {
        this.value = value;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static OptionalBoolean of(Boolean value) {
        return OptionalBoolean.of((boolean)Objects.requireNonNull(value));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static OptionalBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static OptionalBoolean ofNullable(Boolean value) {
        return value == null ? EMPTY : OptionalBoolean.of(value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static OptionalBoolean empty() {
        return EMPTY;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getAsBoolean() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPresent() {
        return this.value != null;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void ifPresent(BooleanConsumer consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean orElse(boolean other) {
        return this.value != null ? this.value : other;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean orElseGet(BooleanSupplier other) {
        return this.value != null ? this.value.booleanValue() : other.getAsBoolean();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public <X extends Throwable> boolean orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        return this.value == null ? "OptionalBoolean.empty" : (this.value != false ? "OptionalBoolean[true]" : "OptionalBoolean[false]");
    }
}

