/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import io.netty.util.internal.EmptyArrays;
import java.util.Objects;

public class SerializedImage {
    public static final SerializedImage EMPTY = new SerializedImage(0, 0, EmptyArrays.EMPTY_BYTES);
    public final int width;
    public final int height;
    public final byte[] data;

    public SerializedImage(int width, int height, byte[] data) {
        this.width = width;
        this.height = height;
        this.data = data;
    }

    public static SerializedImage fromLegacy(byte[] skinData) {
        Objects.requireNonNull(skinData, "skinData");
        switch (skinData.length) {
            case 8192: {
                return new SerializedImage(64, 32, skinData);
            }
            case 16384: {
                return new SerializedImage(64, 64, skinData);
            }
            case 32768: {
                return new SerializedImage(128, 64, skinData);
            }
            case 65536: {
                return new SerializedImage(128, 128, skinData);
            }
        }
        throw new IllegalArgumentException("Unknown legacy skin size");
    }

    public String toString() {
        return "SerializedImage(width=" + this.width + ", height=" + this.height + ")";
    }
}

