/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Watchdog
extends Thread {
    private static final Logger log = LogManager.getLogger(Watchdog.class);
    private final Server server;
    private final long time;
    public volatile boolean running;
    private boolean responding = true;
    private Thread forcedFinalizer;
    private boolean warnedAboutFinalizer;

    public Watchdog(Server server, long time) {
        this.server = server;
        this.time = time;
        this.running = true;
        this.setName("Watchdog");
        this.setDaemon(true);
    }

    public void kill() {
        this.running = false;
        this.interrupt();
    }

    private void checkFinalizer() {
        if (this.forcedFinalizer != null && this.forcedFinalizer.isAlive()) {
            log.fatal("--------- The finalizer thread didn't complete in time! ---------");
            log.fatal("This detection means that the finalizer thread may be stuck and");
            log.fatal("RAM memory might be leaking!");
            log.fatal(" - https://github.com/PowerNukkit/PowerNukkit/issues/new");
            log.fatal("---------------- ForcedFinalizer ----------------");
            Watchdog.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.forcedFinalizer.getId(), Integer.MAX_VALUE));
            log.fatal("-------------------------------------------------");
            this.warnedAboutFinalizer = true;
        } else {
            if (this.warnedAboutFinalizer) {
                log.warn("The ForcedFinalizer has finished");
                this.warnedAboutFinalizer = false;
            }
            this.forcedFinalizer = new Thread(() -> {
                log.trace("Forcing finalization");
                System.runFinalization();
                log.trace("Forced finalization completed");
            });
            this.forcedFinalizer.setName("ForcedFinalizer");
            this.forcedFinalizer.setDaemon(true);
            this.forcedFinalizer.start();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.checkFinalizer();
            long current = this.server.getNextTick();
            if (current != 0L) {
                long diff = System.currentTimeMillis() - current;
                if (!this.responding && diff > this.time * 2L) {
                    System.exit(1);
                }
                if (diff <= this.time) {
                    this.responding = true;
                } else if (this.responding) {
                    log.fatal("--------- Server stopped responding --------- (" + Math.round((double)diff / 1000.0) + "s)");
                    log.fatal("Please report this to PowerNukkit:");
                    log.fatal(" - https://github.com/PowerNukkit/PowerNukkit/issues/new");
                    log.fatal("---------------- Main thread ----------------");
                    Watchdog.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.server.getPrimaryThread().getId(), Integer.MAX_VALUE));
                    log.fatal("---------------- All threads ----------------");
                    ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                    for (int i = 0; i < threads.length; ++i) {
                        if (i != 0) {
                            log.fatal("------------------------------");
                        }
                        Watchdog.dumpThread(threads[i]);
                    }
                    log.fatal("---------------------------------------------");
                    this.responding = false;
                    this.server.forceShutdown();
                }
            }
            try {
                Watchdog.sleep(Math.max(this.time / 4L, 1000L));
            }
            catch (InterruptedException interruption) {
                this.server.getLogger().emergency("The Watchdog Thread has been interrupted and is no longer monitoring the server state");
                this.running = false;
                return;
            }
        }
        this.server.getLogger().warning("Watchdog was stopped");
    }

    private static void dumpThread(ThreadInfo thread) {
        if (thread == null) {
            log.fatal("Attempted to dump a null thread!");
            return;
        }
        log.fatal("Current Thread: " + thread.getThreadName());
        log.fatal("\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockedMonitors().length != 0) {
            log.fatal("\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                log.fatal("\t\tLocked on:" + monitor.getLockedStackFrame());
            }
        }
        log.fatal("\tStack:");
        for (StackTraceElement stack : thread.getStackTrace()) {
            log.fatal("\t\t" + stack);
        }
    }
}

