/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils.collection;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class ConvertingSetWrapper<V1, V2>
extends AbstractSet<V1> {
    private final Function<V1, V2> converter;
    private final Function<V2, V1> reverseConverter;
    private final Set<V2> proxied;

    public ConvertingSetWrapper(Set<V2> proxied, Function<V1, V2> converter, Function<V2, V1> reverseConverter) {
        this.proxied = proxied;
        this.converter = converter;
        this.reverseConverter = reverseConverter;
    }

    @Override
    @Nonnull
    public Iterator<V1> iterator() {
        return new ConvertingIterator();
    }

    @Override
    public int size() {
        return this.proxied.size();
    }

    @Override
    public boolean isEmpty() {
        return this.proxied.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        Function<V1, V2> uncheckedConverter = this.converter;
        V2 converted = uncheckedConverter.apply(o);
        return this.proxied.contains(converted);
    }

    @Override
    public boolean add(V1 v1) {
        return this.proxied.add(this.converter.apply(v1));
    }

    @Override
    public boolean remove(Object o) {
        Function<V1, V2> uncheckedConverter = this.converter;
        V2 converted = uncheckedConverter.apply(o);
        return this.proxied.remove(converted);
    }

    @Override
    public void clear() {
        this.proxied.clear();
    }

    private class ConvertingIterator
    implements Iterator<V1> {
        private final Iterator<V2> proxiedIterator;

        private ConvertingIterator() {
            this.proxiedIterator = ConvertingSetWrapper.this.proxied.iterator();
        }

        @Override
        public void remove() {
            this.proxiedIterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.proxiedIterator.hasNext();
        }

        @Override
        public V1 next() {
            return ConvertingSetWrapper.this.reverseConverter.apply(this.proxiedIterator.next());
        }
    }
}

