/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network;

import io.netty.buffer.ByteBuf;

public final class VarInts {
    public static void writeInt(ByteBuf buffer, int integer) {
        VarInts.encodeUnsigned(buffer, integer << 1 ^ integer >> 31);
    }

    public static int readInt(ByteBuf buffer) {
        int n = (int)VarInts.decodeUnsigned(buffer);
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeUnsignedInt(ByteBuf buffer, long integer) {
        VarInts.encodeUnsigned(buffer, integer);
    }

    public static int readUnsignedInt(ByteBuf buffer) {
        return (int)VarInts.decodeUnsigned(buffer);
    }

    public static void writeLong(ByteBuf buffer, long longInteger) {
        VarInts.encodeUnsigned(buffer, longInteger << 1 ^ longInteger >> 63);
    }

    public static long readLong(ByteBuf buffer) {
        long n = VarInts.decodeUnsigned(buffer);
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeUnsignedLong(ByteBuf buffer, long longInteger) {
        VarInts.encodeUnsigned(buffer, longInteger);
    }

    public static long readUnsignedLong(ByteBuf buffer) {
        return VarInts.decodeUnsigned(buffer);
    }

    private static long decodeUnsigned(ByteBuf buffer) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("Varint was too large");
    }

    private static void encodeUnsigned(ByteBuf buffer, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.writeByte((int)value);
                return;
            }
            buffer.writeByte((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private VarInts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

