/*
 * Decompiled with CFR 0.152.
 */
package net.minecrell.terminalconsole;

import java.util.List;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="minecraftFormatting", category="Converter")
@ConverterKeys(value={"minecraftFormatting"})
@PerformanceSensitive(value={"allocation"})
public class MinecraftFormattingConverter
extends LogEventPatternConverter {
    public static final String KEEP_FORMATTING_PROPERTY = "terminal.keepMinecraftFormatting";
    private static final boolean KEEP_FORMATTING = PropertiesUtil.getProperties().getBooleanProperty("terminal.keepMinecraftFormatting");
    private static final String ANSI_RESET = "\u001b[39;0m";
    private static final char COLOR_CHAR = '\u00a7';
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final String[] ansiCodes = new String[]{"\u001b[0;30;22m", "\u001b[0;34;22m", "\u001b[0;32;22m", "\u001b[0;36;22m", "\u001b[0;31;22m", "\u001b[0;35;22m", "\u001b[0;33;22m", "\u001b[0;37;22m", "\u001b[0;30;1m", "\u001b[0;34;1m", "\u001b[0;32;1m", "\u001b[0;36;1m", "\u001b[0;31;1m", "\u001b[0;35;1m", "\u001b[0;33;1m", "\u001b[0;37;1m", "\u001b[5m", "\u001b[21m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[39;0m"};
    private final boolean ansi;
    private final List<PatternFormatter> formatters;

    protected MinecraftFormattingConverter(List<PatternFormatter> formatters, boolean strip) {
        super("minecraftFormatting", null);
        this.formatters = formatters;
        this.ansi = !strip;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        if (KEEP_FORMATTING || toAppendTo.length() == start) {
            return;
        }
        String content = toAppendTo.substring(start);
        MinecraftFormattingConverter.format(content, toAppendTo, start, this.ansi && TerminalConsoleAppender.isAnsiSupported());
    }

    private static void format(String s2, StringBuilder result, int start, boolean ansi) {
        int next = s2.indexOf(167);
        int last = s2.length() - 1;
        if (next == -1 || next == last) {
            return;
        }
        result.setLength(start + next);
        int pos = next;
        do {
            int format;
            if (pos != next) {
                result.append(s2, pos, next);
            }
            if ((format = LOOKUP.indexOf(s2.charAt(next + 1))) != -1) {
                if (ansi) {
                    result.append(ansiCodes[format]);
                }
                pos = next += 2;
                continue;
            }
            ++next;
        } while ((next = s2.indexOf(167, next)) != -1 && next < last);
        result.append(s2, pos, s2.length());
        if (ansi) {
            result.append(ANSI_RESET);
        }
    }

    public static MinecraftFormattingConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1 || options.length > 2) {
            LOGGER.error("Incorrect number of options on minecraftFormatting. Expected at least 1, max 2 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on minecraftFormatting");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        boolean strip = options.length > 1 && "strip".equals(options[1]);
        return new MinecraftFormattingConverter(formatters, strip);
    }
}

