/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.VariableLengthQuantity;

public class BlockHandle {
    public static final int MAX_ENCODED_LENGTH = 20;
    private final long offset;
    private final int dataSize;

    BlockHandle(long offset, int dataSize) {
        this.offset = offset;
        this.dataSize = dataSize;
    }

    public static BlockHandle readBlockHandle(SliceInput sliceInput) {
        long offset = VariableLengthQuantity.readVariableLengthLong(sliceInput);
        long size = VariableLengthQuantity.readVariableLengthLong(sliceInput);
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Blocks can not be larger than Integer.MAX_VALUE");
        }
        return new BlockHandle(offset, (int)size);
    }

    public static Slice writeBlockHandle(BlockHandle blockHandle) {
        Slice slice = Slices.allocate(20);
        SliceOutput sliceOutput = slice.output();
        BlockHandle.writeBlockHandleTo(blockHandle, sliceOutput);
        return slice.slice();
    }

    public static void writeBlockHandleTo(BlockHandle blockHandle, SliceOutput sliceOutput) {
        VariableLengthQuantity.writeVariableLengthLong(blockHandle.offset, sliceOutput);
        VariableLengthQuantity.writeVariableLengthLong(blockHandle.dataSize, sliceOutput);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getFullBlockSize() {
        return this.dataSize + 5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHandle that = (BlockHandle)o;
        if (this.dataSize != that.dataSize) {
            return false;
        }
        return this.offset == that.offset;
    }

    public int hashCode() {
        int result = (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.dataSize;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockHandle");
        sb.append("{offset=").append(this.offset);
        sb.append(", dataSize=").append(this.dataSize);
        sb.append('}');
        return sb.toString();
    }
}

