/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public final class ByteBufferSupport {
    private static final MethodHandle INVOKE_CLEANER;

    private ByteBufferSupport() {
    }

    public static void unmap(MappedByteBuffer buffer) {
        try {
            INVOKE_CLEANER.invoke(buffer);
        }
        catch (Throwable ignored) {
            throw Throwables.propagate(ignored);
        }
    }

    static {
        MethodHandle invoker;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            invoker = MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo(theUnsafe.get(null));
        }
        catch (Exception e) {
            try {
                Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
                Method cleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                MethodHandle getCleaner = MethodHandles.lookup().unreflect(cleanerMethod);
                Method cleanMethod = cleanerClass.getDeclaredMethod("clean", new Class[0]);
                cleanerMethod.setAccessible(true);
                MethodHandle clean = MethodHandles.lookup().unreflect(cleanMethod);
                clean = MethodHandles.dropArguments(clean, 1, new Class[]{directByteBufferClass});
                invoker = MethodHandles.foldArguments(clean, getCleaner);
            }
            catch (Exception e1) {
                throw new AssertionError((Object)e1);
            }
        }
        INVOKE_CLEANER = invoker;
    }
}

