/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.InterruptibleThread;
import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.ServerKiller;
import cn.nukkit.utils.Utils;
import com.google.common.base.Preconditions;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import io.sentry.Sentry;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Nukkit {
    private static final Logger log = LogManager.getLogger(Nukkit.class);
    public static final Properties GIT_INFO = Nukkit.getGitInfo();
    public static final String VERSION = Nukkit.getVersion();
    public static final String GIT_COMMIT = Nukkit.getGitCommit();
    public static final String API_VERSION = Utils.dynamic("1.0.12");
    public static final String CODENAME = Utils.dynamic("PowerNukkit");
    @Deprecated
    public static final String MINECRAFT_VERSION = ProtocolInfo.MINECRAFT_VERSION;
    @Deprecated
    public static final String MINECRAFT_VERSION_NETWORK = ProtocolInfo.MINECRAFT_VERSION_NETWORK;
    public static final String PATH = System.getProperty("user.dir") + "/";
    public static final String DATA_PATH = System.getProperty("user.dir") + "/";
    public static final String PLUGIN_PATH = DATA_PATH + "plugins";
    public static final long START_TIME = System.currentTimeMillis();
    public static boolean ANSI = true;
    public static boolean TITLE = false;
    public static boolean shortTitle = Nukkit.requiresShortTitle();
    public static int DEBUG = 1;

    public static void main(String[] args) {
        AtomicBoolean disableSentry = new AtomicBoolean(false);
        Sentry.init(options -> {
            options.setDsn("https://a99f9e0c50424fff9f96feb2fd94c22f:6891b003c5874fa4bf407fe45035e3f1@o505263.ingest.sentry.io/5593371");
            options.setRelease(Nukkit.getVersion() + "-" + Nukkit.getGitCommit());
            options.setBeforeSend((event, hint) -> {
                if (disableSentry.get()) {
                    return null;
                }
                try {
                    Server sv = Server.getInstance();
                    event.setExtra("players", (Object)sv.getOnlinePlayers().size());
                    Map<Integer, Level> levels = sv.getLevels();
                    event.setExtra("levels", (Object)levels.size());
                    event.setExtra("chunks", (Object)levels.values().stream().mapToInt(l -> l.getChunks().size()).sum());
                    event.setExtra("tiles", (Object)levels.values().stream().mapToInt(l -> l.getBlockEntities().size()).sum());
                    event.setExtra("entities", (Object)levels.values().stream().mapToInt(l -> l.getEntities().length).sum());
                }
                catch (Exception e) {
                    log.debug("Failed to add player/level/chunk/tiles/entities information", (Throwable)e);
                }
                try {
                    Runtime runtime = Runtime.getRuntime();
                    double totalMB = NukkitMath.round((double)runtime.totalMemory() / 1024.0 / 1024.0, 2);
                    double usedMB = NukkitMath.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1024.0 / 1024.0, 2);
                    double maxMB = NukkitMath.round((double)runtime.maxMemory() / 1024.0 / 1024.0, 2);
                    double usage = usedMB / maxMB * 100.0;
                    event.setExtra("memTotal", (Object)totalMB);
                    event.setExtra("memUsed", (Object)usedMB);
                    event.setExtra("memMax", (Object)maxMB);
                    event.setExtra("memUsage", (Object)usage);
                }
                catch (Exception e) {
                    log.debug("Failed to add memory information", (Throwable)e);
                }
                try {
                    event.setModules(Server.getInstance().getPluginManager().getPlugins().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ((Plugin)entry.getValue()).getDescription().getVersion())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                }
                catch (Exception e) {
                    log.debug("Failed to grab the list of enabled plugins", (Throwable)e);
                }
                return event;
            });
        });
        disableSentry.set(Boolean.parseBoolean(System.getProperty("disableSentry", "false")));
        Path propertiesPath = Paths.get(DATA_PATH, "server.properties");
        if (!disableSentry.get() && Files.isRegularFile(propertiesPath, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(propertiesPath.toFile());){
                properties.load(reader);
                disableSentry.set(Boolean.parseBoolean(properties.getProperty("disable-auto-bug-report", "false")));
            }
            catch (IOException e) {
                log.error("Failed to load server.properties to check disable-auto-bug-report.", (Throwable)e);
            }
        }
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("log4j.skipJansi", "false");
        System.getProperties().putIfAbsent("io.netty.allocator.type", "unpooled");
        System.setProperty("leveldb.mmap", "true");
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpSpec = parser.accepts("help", "Shows this page").forHelp();
        OptionSpecBuilder ansiSpec = parser.accepts("disable-ansi", "Disables console coloring");
        OptionSpecBuilder titleSpec = parser.accepts("enable-title", "Enables title at the top of the window");
        ArgumentAcceptingOptionSpec vSpec = parser.accepts("v", "Set verbosity of logging").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec verbositySpec = parser.accepts("verbosity", "Set verbosity of logging").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec languageSpec = parser.accepts("language", "Set a predefined language").withOptionalArg().ofType(String.class);
        OptionSet options2 = parser.parse(args);
        if (options2.has((OptionSpec)helpSpec)) {
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        ANSI = !options2.has((OptionSpec)ansiSpec);
        TITLE = options2.has((OptionSpec)titleSpec);
        String verbosity = (String)options2.valueOf((OptionSpec)vSpec);
        if (verbosity == null) {
            verbosity = (String)options2.valueOf((OptionSpec)verbositySpec);
        }
        if (verbosity != null) {
            try {
                org.apache.logging.log4j.Level level = org.apache.logging.log4j.Level.valueOf((String)verbosity);
                Nukkit.setLogLevel(level);
            }
            catch (Exception level) {
                // empty catch block
            }
        }
        String language = (String)options2.valueOf((OptionSpec)languageSpec);
        try {
            if (TITLE) {
                System.out.print("\u001b]0;Nukkit is starting up...\u0007");
            }
            new Server(PATH, DATA_PATH, PLUGIN_PATH, language);
        }
        catch (Throwable t) {
            log.catching(t);
        }
        if (TITLE) {
            System.out.print("\u001b]0;Stopping Server...\u0007");
        }
        log.info("Stopping other threads");
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!(thread instanceof InterruptibleThread)) continue;
            log.debug("Stopping {} thread", (Object)thread.getClass().getSimpleName());
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        ServerKiller killer = new ServerKiller(8L);
        killer.start();
        if (TITLE) {
            System.out.print("\u001b]0;Server Stopped\u0007");
        }
        System.exit(0);
    }

    private static boolean requiresShortTitle() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("windows") && (osName.contains("windows 8") || osName.contains("2012"));
    }

    private static Properties getGitInfo() {
        InputStream gitFileStream = Nukkit.class.getClassLoader().getResourceAsStream("git.properties");
        if (gitFileStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(gitFileStream);
        }
        catch (IOException e) {
            return null;
        }
        return properties;
    }

    /*
     * Exception decompiling
     */
    private static String getVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getGitCommit() {
        String commitId;
        StringBuilder version = new StringBuilder();
        version.append("git-");
        if (GIT_INFO == null || (commitId = GIT_INFO.getProperty("git.commit.id.abbrev")) == null) {
            return version.append("null").toString();
        }
        return version.append(commitId).toString();
    }

    public static void setLogLevel(org.apache.logging.log4j.Level level) {
        Preconditions.checkNotNull((Object)level, (Object)"level");
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration log4jConfig = ctx.getConfiguration();
        LoggerConfig loggerConfig = log4jConfig.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static org.apache.logging.log4j.Level getLogLevel() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration log4jConfig = ctx.getConfiguration();
        LoggerConfig loggerConfig = log4jConfig.getLoggerConfig("");
        return loggerConfig.getLevel();
    }
}

