/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBamboo;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockBambooSapling
extends BlockFlowable {
    @PowerNukkitOnly
    public BlockBambooSapling() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockBambooSapling(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 419;
    }

    @Override
    public String getName() {
        return "Bamboo Sapling";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.isSupportInvalid()) {
                this.level.useBreakOn(this, null, null, true);
            } else {
                Block up = this.up();
                if (up.getId() == 418) {
                    BlockBamboo upperBamboo = (BlockBamboo)up;
                    BlockBamboo newState = new BlockBamboo();
                    newState.setThick(upperBamboo.isThick());
                    this.level.setBlock((Vector3)this, newState, true, true);
                }
            }
            return type;
        }
        if (type == 2) {
            Block up = this.up();
            if (this.getAge() == 0 && up.getId() == 0 && this.level.getFullLight(up) >= 9 && ThreadLocalRandom.current().nextInt(3) == 0) {
                BlockBamboo newState = new BlockBamboo();
                newState.setLeafSize(1);
                BlockGrowEvent blockGrowEvent = new BlockGrowEvent(up, newState);
                this.level.getServer().getPluginManager().callEvent(blockGrowEvent);
                if (!blockGrowEvent.isCancelled()) {
                    Block newState1 = blockGrowEvent.getNewState();
                    newState1.y = up.y;
                    newState1.x = this.x;
                    newState1.z = this.z;
                    newState1.level = this.level;
                    newState1.place(this.toItem(), up, this, BlockFace.DOWN, 0.5, 0.5, 0.5, null);
                }
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.isSupportInvalid()) {
            return false;
        }
        if (this.getLevelBlock() instanceof BlockLiquid || this.getLevelBlockAtLayer(1) instanceof BlockLiquid) {
            return false;
        }
        this.level.setBlock((Vector3)this, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        boolean isBoneMeal = item.isFertilizer();
        if (isBoneMeal || item.getBlock() != null && item.getBlockId() == 418) {
            boolean success = false;
            Block block = this.up();
            if (block.getId() == 0) {
                success = this.grow(block);
            }
            if (success) {
                if (player != null && (player.gamemode & 1) == 0) {
                    --item.count;
                }
                if (isBoneMeal) {
                    this.level.addParticle(new BoneMealParticle(this));
                } else {
                    this.level.addSound(block, Sound.BLOCK_BAMBOO_PLACE, 0.8f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    public boolean grow(Block up) {
        BlockBamboo bamboo = new BlockBamboo();
        bamboo.x = this.x;
        bamboo.y = this.y;
        bamboo.z = this.z;
        bamboo.level = this.level;
        return bamboo.grow(up);
    }

    private boolean isSupportInvalid() {
        int downId = this.down().getId();
        return downId != 3 && downId != 2 && downId != 12 && downId != 13 && downId != 243;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @PowerNukkitOnly
    public int getAge() {
        return this.getDamage() & 1;
    }

    @PowerNukkitOnly
    public void setAge(int age) {
        age = MathHelper.clamp(age, 0, 1) & 1;
        this.setDamage(this.getDamage() & (DATA_MASK ^ 1) | age);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockBamboo());
    }

    @Override
    public double getMinX() {
        return this.x + 0.125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.875;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.125;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.875;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

