/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockLever;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockentity.BlockEntityBell;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.BellAttachmentType;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.block.BellRingEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockBell
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable,
BlockEntityHolder<BlockEntityBell> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BellAttachmentType> ATTACHMENT_TYPE = new ArrayBlockProperty<BellAttachmentType>("attachment", false, BellAttachmentType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, ATTACHMENT_TYPE, CommonBlockProperties.TOGGLE);
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic values", replaceWith="BellAttachmentType.STANDING")
    public static final int TYPE_ATTACHMENT_STANDING = 0;
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic values", replaceWith="BellAttachmentType.HANGING")
    public static final int TYPE_ATTACHMENT_HANGING = 1;
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic values", replaceWith="BellAttachmentType.SIDE")
    public static final int TYPE_ATTACHMENT_SIDE = 2;
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic values", replaceWith="BellAttachmentType.MULTIPLE")
    public static final int TYPE_ATTACHMENT_MULTIPLE = 3;

    @PowerNukkitOnly
    public BlockBell() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockBell(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Bell";
    }

    @Override
    public int getId() {
        return 461;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBell> getBlockEntityClass() {
        return BlockEntityBell.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Bell";
    }

    private boolean isConnectedTo(BlockFace connectedFace, BellAttachmentType attachmentType, BlockFace blockFace) {
        BlockFace.Axis faceAxis = connectedFace.getAxis();
        switch (attachmentType) {
            case STANDING: {
                if (faceAxis == BlockFace.Axis.Y) {
                    return connectedFace == BlockFace.DOWN;
                }
                return blockFace.getAxis() != faceAxis;
            }
            case HANGING: {
                return connectedFace == BlockFace.UP;
            }
            case SIDE: {
                return connectedFace == blockFace.getOpposite();
            }
            case MULTIPLE: {
                return connectedFace == blockFace || connectedFace == blockFace.getOpposite();
            }
        }
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        BellAttachmentType attachmentType = this.getBellAttachmentType();
        BlockFace blockFace = this.getBlockFace();
        boolean north = this.isConnectedTo(BlockFace.NORTH, attachmentType, blockFace);
        boolean south = this.isConnectedTo(BlockFace.SOUTH, attachmentType, blockFace);
        boolean west = this.isConnectedTo(BlockFace.WEST, attachmentType, blockFace);
        boolean east = this.isConnectedTo(BlockFace.EAST, attachmentType, blockFace);
        boolean up = this.isConnectedTo(BlockFace.UP, attachmentType, blockFace);
        boolean down = this.isConnectedTo(BlockFace.DOWN, attachmentType, blockFace);
        double n = north ? 0.0 : 0.25;
        double s = south ? 1.0 : 0.75;
        double w = west ? 0.0 : 0.25;
        double e = east ? 1.0 : 0.75;
        double d = down ? 0.0 : 0.25;
        double u = up ? 1.0 : 0.75;
        return new SimpleAxisAlignedBB(this.x + w, this.y + d, this.z + n, this.x + e, this.y + u, this.z + s);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        AxisAlignedBB blockBoundingBox;
        AxisAlignedBB boundingBox;
        if (entity instanceof EntityItem && entity.positionChanged && (boundingBox = entity.getBoundingBox()).intersectsWith(blockBoundingBox = this.getCollisionBoundingBox())) {
            Vector3 entityCenter = new Vector3((boundingBox.getMaxX() - boundingBox.getMinX()) / 2.0, (boundingBox.getMaxY() - boundingBox.getMinY()) / 2.0, (boundingBox.getMaxZ() - boundingBox.getMinZ()) / 2.0);
            Vector3 blockCenter = new Vector3((blockBoundingBox.getMaxX() - blockBoundingBox.getMinX()) / 2.0, (blockBoundingBox.getMaxY() - blockBoundingBox.getMinY()) / 2.0, (blockBoundingBox.getMaxZ() - blockBoundingBox.getMinZ()) / 2.0);
            Location entityPos = entity.add(entityCenter);
            Position blockPos = this.add(blockBoundingBox.getMinX() - this.x + blockCenter.x, blockBoundingBox.getMinY() - this.y + blockCenter.y, blockBoundingBox.getMinZ() - this.z + blockCenter.z);
            Vector3 entityVector = ((Vector3)entityPos).subtract(blockPos);
            entityVector = entityVector.normalize().multiply(0.4);
            entityVector.y = Math.max(0.15, entityVector.y);
            if (this.ring(entity, BellRingEvent.RingCause.DROPPED_ITEM)) {
                entity.setMotion(entityVector);
            }
        }
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this.recalculateBoundingBox().expand(1.0E-6, 1.0E-6, 1.0E-6);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        return this.ring(player, player != null ? BellRingEvent.RingCause.HUMAN_INTERACTION : BellRingEvent.RingCause.UNKNOWN);
    }

    @PowerNukkitOnly
    public boolean ring(Entity causeEntity, BellRingEvent.RingCause cause) {
        return this.ring(causeEntity, cause, null);
    }

    @PowerNukkitOnly
    public boolean ring(Entity causeEntity, BellRingEvent.RingCause cause, BlockFace hitFace) {
        BlockEntityBell bell = (BlockEntityBell)this.getOrCreateBlockEntity();
        boolean addException = true;
        BlockFace blockFace = this.getBlockFace();
        if (hitFace == null) {
            if (causeEntity != null) {
                if (causeEntity instanceof EntityItem) {
                    int z;
                    int x;
                    Position blockMid = this.add(0.5, 0.5, 0.5);
                    Vector3 vector = causeEntity.subtract(blockMid).normalize();
                    int n = vector.x < 0.0 ? -1 : (x = vector.x > 0.0 ? 1 : 0);
                    int n2 = vector.z < 0.0 ? -1 : (z = vector.z > 0.0 ? 1 : 0);
                    if (x != 0 && z != 0) {
                        if (Math.abs(vector.x) < Math.abs(vector.z)) {
                            x = 0;
                        } else {
                            z = 0;
                        }
                    }
                    hitFace = blockFace;
                    for (BlockFace face : BlockFace.values()) {
                        if (face.getXOffset() != x || face.getZOffset() != z) continue;
                        hitFace = face;
                        break;
                    }
                } else {
                    hitFace = causeEntity.getDirection();
                }
            } else {
                hitFace = blockFace;
            }
        }
        switch (this.getBellAttachmentType()) {
            case STANDING: {
                if (hitFace.getAxis() == blockFace.getAxis()) break;
                return false;
            }
            case MULTIPLE: {
                if (hitFace.getAxis() != blockFace.getAxis()) break;
                return false;
            }
            case SIDE: {
                if (hitFace.getAxis() != blockFace.getAxis()) break;
                addException = false;
                break;
            }
        }
        BellRingEvent event = new BellRingEvent(this, cause, causeEntity);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        bell.setDirection(hitFace.getOpposite().getHorizontalIndex());
        bell.setTicks(0);
        bell.setRinging(true);
        if (addException && causeEntity instanceof Player) {
            bell.spawnExceptions.add((Player)causeEntity);
        }
        return true;
    }

    private boolean checkSupport() {
        switch (this.getBellAttachmentType()) {
            case STANDING: {
                if (!this.checkSupport(this.down(), BlockFace.UP)) break;
                return true;
            }
            case HANGING: {
                if (!this.checkSupport(this.up(), BlockFace.DOWN)) break;
                return true;
            }
            case MULTIPLE: {
                BlockFace blockFace = this.getBlockFace();
                if (!this.checkSupport(this.getSide(blockFace), blockFace.getOpposite()) || !this.checkSupport(this.getSide(blockFace.getOpposite()), blockFace)) break;
                return true;
            }
            case SIDE: {
                BlockFace blockFace = this.getBlockFace();
                if (!this.checkSupport(this.getSide(blockFace.getOpposite()), blockFace)) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkSupport(Block support, BlockFace attachmentFace) {
        if (BlockLever.isSupportValid(support, attachmentFace)) {
            return true;
        }
        if (attachmentFace == BlockFace.DOWN) {
            switch (support.getId()) {
                case 101: 
                case 154: 
                case 541: {
                    return true;
                }
            }
            return support instanceof BlockFence || support instanceof BlockWallBase;
        }
        if (support instanceof BlockCauldron) {
            return attachmentFace == BlockFace.UP;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.checkSupport()) {
                this.level.useBreakOn(this);
            }
            return type;
        }
        if (type == 6 && this.level.getServer().isRedstoneEnabled()) {
            if (this.isGettingPower()) {
                if (!this.isToggled()) {
                    this.setToggled(true);
                    this.level.setBlock((Vector3)this, this, true, true);
                    this.ring(null, BellRingEvent.RingCause.REDSTONE);
                }
            } else if (this.isToggled()) {
                this.setToggled(false);
                this.level.setBlock((Vector3)this, this, true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isGettingPower() {
        for (BlockFace side : BlockFace.values()) {
            Block b = this.getSide(side);
            if (b.getId() == 55 && b.getDamage() > 0 && b.y >= this.getY()) {
                return true;
            }
            if (!this.level.isSidePowered(b, side)) continue;
            return true;
        }
        return this.level.isBlockPowered(this.getLocation());
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (block.canBeReplaced() && block.getId() != 0 && block.getId() != 415 && !(block instanceof BlockLiquid)) {
            face = BlockFace.UP;
        }
        BlockFace playerDirection = player != null ? player.getDirection() : BlockFace.EAST;
        switch (face) {
            case UP: {
                this.setBellAttachmentType(BellAttachmentType.STANDING);
                this.setBlockFace(playerDirection.getOpposite());
                break;
            }
            case DOWN: {
                this.setBellAttachmentType(BellAttachmentType.HANGING);
                this.setBlockFace(playerDirection.getOpposite());
                break;
            }
            default: {
                this.setBlockFace(face);
                if (this.checkSupport(block.getSide(face), face.getOpposite())) {
                    this.setBellAttachmentType(BellAttachmentType.MULTIPLE);
                    break;
                }
                this.setBellAttachmentType(BellAttachmentType.SIDE);
            }
        }
        if (!this.checkSupport()) {
            return false;
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this) != null;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean onProjectileHit(@Nonnull Entity projectile, @Nonnull Position position, @Nonnull Vector3 motion) {
        this.ring(projectile, BellRingEvent.RingCause.PROJECTILE);
        if (projectile.isOnFire() && projectile instanceof EntityArrow && this.level.getBlock(projectile).getId() == 0) {
            this.level.setBlock((Vector3)projectile, Block.get(51), true);
        }
        return true;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BellAttachmentType getBellAttachmentType() {
        return this.getPropertyValue(ATTACHMENT_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBellAttachmentType(BellAttachmentType bellAttachmentType) {
        this.setPropertyValue(ATTACHMENT_TYPE, bellAttachmentType);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic values.", replaceWith="getBellAttachmentType()")
    public int getAttachmentType() {
        return this.getBellAttachmentType().ordinal();
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic values.", replaceWith="setBellAttachmentType(BellAttachmentType)")
    public void setAttachmentType(int attachmentType) {
        this.setBellAttachmentType(BellAttachmentType.values()[attachmentType]);
    }

    @PowerNukkitOnly
    public boolean isToggled() {
        return this.getBooleanValue(CommonBlockProperties.TOGGLE);
    }

    @PowerNukkitOnly
    public void setToggled(boolean toggled) {
        this.setBooleanValue(CommonBlockProperties.TOGGLE, toggled);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockBell());
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 25.0;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GOLD_BLOCK_COLOR;
    }
}

