/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBrewingStand;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBrewingStand;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;
import javax.annotation.Nonnull;

public class BlockBrewingStand
extends BlockSolidMeta {
    public BlockBrewingStand() {
        this(0);
    }

    public BlockBrewingStand(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Brewing Stand";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getId() {
        return 117;
    }

    @Override
    public int getLightLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference(info="Remove placement restrictions, they don't exists in vanilla", since="1.3.1.2-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityBrewingStand brewing;
        this.getLevel().setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "BrewingStand").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return (brewing = (BlockEntityBrewingStand)BlockEntity.createBlockEntity("BrewingStand", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0])) != null;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player != null) {
            BlockEntityBrewingStand brewing;
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityBrewingStand) {
                brewing = (BlockEntityBrewingStand)t;
            } else {
                CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "BrewingStand").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
                brewing = (BlockEntityBrewingStand)BlockEntity.createBlockEntity("BrewingStand", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
                if (brewing == null) {
                    return false;
                }
            }
            if (brewing.namedTag.contains("Lock") && brewing.namedTag.get("Lock") instanceof StringTag && !brewing.namedTag.getString("Lock").equals(item.getCustomName())) {
                return false;
            }
            player.addWindow(brewing.getInventory());
        }
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBrewingStand();
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityBrewingStand) {
            return ContainerInventory.calculateRedstone(((BlockEntityBrewingStand)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

