/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.event.block.BlockFromToEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BubbleParticle;
import cn.nukkit.level.particle.SplashParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockBubbleColumn
extends BlockTransparentMeta {
    @PowerNukkitOnly
    public BlockBubbleColumn() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockBubbleColumn(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 415;
    }

    @Override
    public String getName() {
        return "Bubble Column";
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        return Item.EMPTY_ARRAY;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockAir());
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBePlaced() {
        return false;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return null;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity.canBeMovedByCurrents()) {
            if (this.up().getId() == 0) {
                entity.motionY = this.getDamage() == 1 ? Math.max(-0.9, entity.motionY - 0.03) : Math.min(1.8, entity.motionY + 0.1);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                for (int i = 0; i < 2; ++i) {
                    this.level.addParticle(new SplashParticle(this.add(random.nextFloat(), random.nextFloat() + 1.0f, random.nextFloat())));
                    this.level.addParticle(new BubbleParticle(this.add(random.nextFloat(), random.nextFloat() + 1.0f, random.nextFloat())));
                }
            } else {
                entity.motionY = this.getDamage() == 1 ? Math.max(-0.3, entity.motionY - 0.3) : Math.min(0.7, entity.motionY + 0.06);
            }
            entity.motionChanged = true;
            entity.resetFallDistance();
        }
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (this.down().getId() == 213) {
            this.setDamage(1);
        }
        this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
        this.getLevel().setBlock((Vector3)this, this, true, true);
        return true;
    }

    @Override
    public double getHardness() {
        return 100.0;
    }

    @Override
    public double getResistance() {
        return 500.0;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            BlockFromToEvent event;
            Block up;
            Block down;
            Block water = this.getLevelBlockAtLayer(1);
            if (!(water instanceof BlockWater) || water.getDamage() != 0 && water.getDamage() != 8) {
                this.fadeOut(water);
                return type;
            }
            if (water.getDamage() == 8) {
                water.setDamage(0);
                this.getLevel().setBlock(this, 1, water, true, false);
            }
            if ((down = this.down()).getId() == 415) {
                if (down.getDamage() != this.getDamage()) {
                    this.getLevel().setBlock((Vector3)this, down, true, true);
                }
            } else if (down.getId() == 213) {
                if (this.getDamage() != 1) {
                    this.setDamage(1);
                    this.getLevel().setBlock((Vector3)this, this, true, true);
                }
            } else if (down.getId() == 88) {
                if (this.getDamage() != 0) {
                    this.setDamage(0);
                    this.getLevel().setBlock((Vector3)this, this, true, true);
                }
            } else {
                this.fadeOut(water);
                return type;
            }
            if ((up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8) && !(event = new BlockFromToEvent(this, up)).isCancelled()) {
                this.getLevel().setBlock(up, 1, new BlockWater(), true, false);
                this.getLevel().setBlock(up, 0, new BlockBubbleColumn(this.getDamage()), true, true);
            }
            return type;
        }
        return 0;
    }

    private void fadeOut(Block water) {
        BlockFadeEvent event = new BlockFadeEvent(this, water.clone());
        if (!event.isCancelled()) {
            this.getLevel().setBlock(this, 1, new BlockAir(), true, false);
            this.getLevel().setBlock(this, 0, event.getNewState(), true, true);
        }
    }
}

