/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockCoral
extends BlockFlowable {
    public static final int TYPE_TUBE = 0;
    public static final int TYPE_BRAIN = 1;
    public static final int TYPE_BUBBLE = 2;
    public static final int TYPE_FIRE = 3;
    public static final int TYPE_HORN = 4;

    public BlockCoral() {
        this(0);
    }

    public BlockCoral(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 386;
    }

    public boolean isDead() {
        return (this.getDamage() & 8) == 8;
    }

    public void setDead(boolean dead) {
        if (dead) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() ^ 8);
        }
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (!down.isSolid()) {
                this.getLevel().useBreakOn(this);
            } else if (!this.isDead()) {
                this.getLevel().scheduleUpdate(this, 60 + ThreadLocalRandom.current().nextInt(40));
            }
            return type;
        }
        if (type == 3) {
            BlockFadeEvent event;
            if (!(this.isDead() || this.getLevelBlockAtLayer(1) instanceof BlockWater || this.getLevelBlockAtLayer(1) instanceof BlockIceFrosted || (event = new BlockFadeEvent(this, new BlockCoral(this.getDamage() | 8))).isCancelled())) {
                this.setDead(true);
                this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        int waterDamage;
        Block down = this.down();
        Block layer1 = block.getLevelBlockAtLayer(1);
        boolean hasWater = layer1 instanceof BlockWater;
        if (layer1.getId() != 0 && (!hasWater || (waterDamage = layer1.getDamage()) != 0 && waterDamage != 8)) {
            return false;
        }
        if (hasWater && layer1.getDamage() == 8) {
            this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
        }
        if (down.isSolid()) {
            this.getLevel().setBlock(this, 0, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Tube Coral", "Brain Coral", "Bubble Coral", "Fire Coral", "Horn Coral", "Tube Coral", "Tube Coral", "Tube Coral"};
        String name = names[this.getDamage() & 7];
        if (this.isDead()) {
            return "Dead " + name;
        }
        return name;
    }

    @Override
    public BlockColor getColor() {
        if (this.isDead()) {
            return BlockColor.GRAY_BLOCK_COLOR;
        }
        BlockColor[] colors = new BlockColor[]{BlockColor.BLUE_BLOCK_COLOR, BlockColor.PINK_BLOCK_COLOR, BlockColor.PURPLE_BLOCK_COLOR, BlockColor.RED_BLOCK_COLOR, BlockColor.YELLOW_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR};
        return colors[this.getDamage() & 7];
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getEnchantment(16) != null) {
            return super.getDrops(item);
        }
        return Item.EMPTY_ARRAY;
    }
}

