/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCoralFanDead;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockCoralFan
extends BlockFlowable
implements Faceable {
    @PowerNukkitOnly
    public BlockCoralFan() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockCoralFan(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 388;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Tube Coral Fan", "Brain Coral Fan", "Bubble Coral Fan", "Fire Coral Fan", "Horn Coral Fan"};
        return names[this.getType()];
    }

    @Override
    public BlockColor getColor() {
        BlockColor[] colors = new BlockColor[]{BlockColor.BLUE_BLOCK_COLOR, BlockColor.PINK_BLOCK_COLOR, BlockColor.PURPLE_BLOCK_COLOR, BlockColor.RED_BLOCK_COLOR, BlockColor.YELLOW_BLOCK_COLOR};
        return colors[this.getType()];
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @PowerNukkitOnly
    public boolean isDead() {
        return false;
    }

    @PowerNukkitOnly
    public int getType() {
        return this.getDamage() & 7;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(((this.getDamage() & 8) >> 3) + 1);
    }

    @PowerNukkitOnly
    public BlockFace getRootsFace() {
        return BlockFace.DOWN;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block side = this.getSide(this.getRootsFace());
            if (!side.isSolid() || side.getId() == 213 || side.getId() == 88) {
                this.getLevel().useBreakOn(this);
            } else {
                this.getLevel().scheduleUpdate(this, 60 + ThreadLocalRandom.current().nextInt(40));
            }
            return type;
        }
        if (type == 3) {
            BlockFadeEvent event;
            Block side = this.getSide(this.getRootsFace());
            if (side.getId() == 79) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            if (!(this.isDead() || this.getLevelBlockAtLayer(1) instanceof BlockWater || this.getLevelBlockAtLayer(1) instanceof BlockIceFrosted || (event = new BlockFadeEvent(this, new BlockCoralFanDead(this.getDamage()))).isCancelled())) {
                this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
            }
            return type;
        }
        if (type == 2) {
            if ((this.getDamage() & 8) == 0) {
                this.setDamage(this.getDamage() | 8);
            } else {
                this.setDamage(this.getDamage() ^ 8);
            }
            this.getLevel().setBlock((Vector3)this, this, true, true);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (face == BlockFace.DOWN) {
            return false;
        }
        Block layer1 = block.getLevelBlockAtLayer(1);
        boolean hasWater = layer1 instanceof BlockWater;
        if (layer1.getId() != 0 && (!hasWater || layer1.getDamage() != 0 && layer1.getDamage() != 8)) {
            return false;
        }
        if (hasWater && layer1.getDamage() == 8) {
            this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
        }
        if (!target.isSolid() || target.getId() == 213 || target.getId() == 88) {
            return false;
        }
        if (face == BlockFace.UP) {
            double rotation = player.yaw % 360.0;
            if (rotation < 0.0) {
                rotation += 360.0;
            }
            int axisBit = rotation >= 0.0 && rotation < 12.0 || 342.0 <= rotation && rotation < 360.0 ? 0 : 8;
            this.setDamage(this.getDamage() & 7 | axisBit);
            this.getLevel().setBlock(this, 0, hasWater ? new BlockCoralFan(this.getDamage()) : new BlockCoralFanDead(this.getDamage()), true, true);
        } else {
            int deadBlockId;
            int faceBit;
            int type = this.getType();
            int typeBit = type % 2;
            int deadBit = this.isDead() ? 1 : 0;
            switch (face) {
                case WEST: {
                    faceBit = 0;
                    break;
                }
                case EAST: {
                    faceBit = 1;
                    break;
                }
                case NORTH: {
                    faceBit = 2;
                    break;
                }
                default: {
                    faceBit = 3;
                }
            }
            int deadData = faceBit << 2 | deadBit << 1 | typeBit;
            switch (type) {
                default: {
                    deadBlockId = 390;
                    break;
                }
                case 2: 
                case 3: {
                    deadBlockId = 391;
                    break;
                }
                case 4: {
                    deadBlockId = 392;
                }
            }
            this.getLevel().setBlock(this, 0, Block.get(deadBlockId, deadData), true, true);
        }
        return true;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(this.getItemId(), this.getDamage() ^ 8);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getEnchantment(16) != null) {
            return super.getDrops(item);
        }
        return Item.EMPTY_ARRAY;
    }
}

