/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLever;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import javax.annotation.Nonnull;

public class BlockLadder
extends BlockTransparentMeta
implements Faceable {
    private double offMinX;
    private double offMinZ;
    private double offMaxX;
    private double offMaxZ;

    public BlockLadder() {
        this(0);
    }

    public BlockLadder(int meta) {
        super(meta);
        this.calculateOffsets();
    }

    @Override
    public String getName() {
        return "Ladder";
    }

    @Override
    public int getId() {
        return 65;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    private void calculateOffsets() {
        double f = 0.1875;
        switch (this.getDamage()) {
            case 2: {
                this.offMinX = 0.0;
                this.offMinZ = 1.0 - f;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
                break;
            }
            case 3: {
                this.offMinX = 0.0;
                this.offMinZ = 0.0;
                this.offMaxX = 1.0;
                this.offMaxZ = f;
                break;
            }
            case 4: {
                this.offMinX = 1.0 - f;
                this.offMinZ = 0.0;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
                break;
            }
            case 5: {
                this.offMinX = 0.0;
                this.offMinZ = 0.0;
                this.offMaxX = f;
                this.offMaxZ = 1.0;
                break;
            }
            default: {
                this.offMinX = 0.0;
                this.offMinZ = 1.0;
                this.offMaxX = 1.0;
                this.offMaxZ = 1.0;
            }
        }
    }

    @Override
    public void setDamage(int meta) {
        super.setDamage(meta);
        this.calculateOffsets();
    }

    @Override
    public double getMinX() {
        return this.x + this.offMinX;
    }

    @Override
    public double getMinZ() {
        return this.z + this.offMinZ;
    }

    @Override
    public double getMaxX() {
        return this.x + this.offMaxX;
    }

    @Override
    public double getMaxZ() {
        return this.z + this.offMaxZ;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return super.recalculateBoundingBox();
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (face.getHorizontalIndex() == -1 || !this.isSupportValid(target, face)) {
            return false;
        }
        this.setDamage(face.getIndex());
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    private boolean isSupportValid(Block support, BlockFace face) {
        switch (support.getId()) {
            case 20: 
            case 102: 
            case 138: 
            case 160: 
            case 241: {
                return false;
            }
        }
        return BlockLever.isSupportValid(support, face);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public int onUpdate(int type) {
        int[] faces;
        BlockFace face;
        if (type == 1 && !this.isSupportValid(this.getSide(face = BlockFace.fromIndex((faces = new int[]{0, 1, 3, 2, 5, 4})[this.getDamage()])), face.getOpposite())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(65, 0, 1)};
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

