/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRedstoneLamp;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.RedstoneComponent;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public class BlockRedstoneLampLit
extends BlockRedstoneLamp
implements RedstoneComponent {
    @Override
    public String getName() {
        return "Lit Redstone Lamp";
    }

    @Override
    public int getId() {
        return 124;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(123));
    }

    @Override
    @PowerNukkitDifference(info="Redstone Event on scheduled update part + use #isGettingPower() method + trigger observer.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if (!(type != 1 && type != 6 || this.isGettingPower())) {
            this.level.scheduleUpdate(this, 4);
            return 1;
        }
        if (type == 3 && !this.isGettingPower()) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
            this.level.updateComparatorOutputLevelSelective(this, true);
            this.level.setBlock((Vector3)this, Block.get(123), false, false);
        }
        return 0;
    }
}

