/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockSeaPickle
extends BlockFlowable {
    @PowerNukkitOnly
    public BlockSeaPickle() {
        this(0);
    }

    @PowerNukkitOnly
    protected BlockSeaPickle(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 411;
    }

    @Override
    public String getName() {
        return "Sea Pickle";
    }

    @PowerNukkitOnly
    public boolean isDead() {
        return (this.getDamage() & 4) == 4;
    }

    @PowerNukkitOnly
    public void setDead(boolean dead) {
        if (dead) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            BlockFadeEvent event;
            Block down = this.down();
            if (!down.isSolid() || down.getId() == 79) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            Block layer1 = this.getLevelBlockAtLayer(1);
            if (layer1 instanceof BlockWater || layer1.getId() == 207) {
                if (this.isDead() && (layer1.getId() == 207 || layer1.getDamage() == 0 || layer1.getDamage() == 8)) {
                    BlockFadeEvent event2 = new BlockFadeEvent(this, new BlockSeaPickle(this.getDamage() ^ 4));
                    if (!event2.isCancelled()) {
                        this.getLevel().setBlock((Vector3)this, event2.getNewState(), true, true);
                    }
                    return type;
                }
            } else if (!this.isDead() && !(event = new BlockFadeEvent(this, new BlockSeaPickle(this.getDamage() ^ 4))).isCancelled()) {
                this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.getId() == 411 && (target.getDamage() & 3) < 3) {
            target.setDamage(target.getDamage() + 1);
            this.getLevel().setBlock((Vector3)target, target, true, true);
            return true;
        }
        Block down = block.down().getLevelBlockAtLayer(0);
        if (down.isSolid() && down.getId() != 79) {
            if (down instanceof BlockSlab || down instanceof BlockStairs || block.getId() == 415) {
                return false;
            }
            Block layer1 = block.getLevelBlockAtLayer(1);
            if (layer1 instanceof BlockWater) {
                if (layer1.getDamage() != 0 && layer1.getDamage() != 8) {
                    return false;
                }
                if (layer1.getDamage() == 8) {
                    this.getLevel().setBlock(block, 1, new BlockWater(), true, false);
                }
            } else {
                this.setDead(true);
            }
            this.getLevel().setBlock(block, 0, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer() && this.down().getId() == 387 && !this.isDead()) {
            Block[] blocksAround;
            BlockSeaPickle block = (BlockSeaPickle)this.clone();
            block.setDamage(3);
            BlockGrowEvent blockGrowEvent = new BlockGrowEvent(this, block);
            Server.getInstance().getPluginManager().callEvent(blockGrowEvent);
            if (blockGrowEvent.isCancelled()) {
                return false;
            }
            this.getLevel().setBlock((Vector3)this, blockGrowEvent.getNewState(), false, true);
            this.level.addParticle(new BoneMealParticle(this));
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (Block blockNearby : blocksAround = this.getLevel().getCollisionBlocks(new SimpleAxisAlignedBB(this.x - 2.0, this.y - 2.0, this.z - 2.0, this.x + 3.0, this.y, this.z + 3.0))) {
                BlockSpreadEvent blockSpreadEvent;
                Block up;
                if (blockNearby.getId() != 387 || !((up = blockNearby.up()) instanceof BlockWater) || up.getDamage() != 0 && up.getDamage() != 8 || random.nextInt(6) != 0) continue;
                Vector2 vector2 = new Vector2(up.x, up.z);
                Vector2 vector22 = new Vector2(this.x, this.z);
                if (!(vector2.distance(vector22) <= 2.0) || (blockSpreadEvent = new BlockSpreadEvent(up, this, new BlockSeaPickle(random.nextInt(3)))).isCancelled()) continue;
                this.getLevel().setBlock(up, 1, new BlockWater(), true, false);
                this.getLevel().setBlock((Vector3)up, blockSpreadEvent.getNewState(), true, true);
            }
        }
        return super.onActivate(item, player);
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getLightLevel() {
        if (this.isDead()) {
            return 0;
        }
        return (this.getDamage() + 2) * 3;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockSeaPickle());
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemBlock(new BlockSeaPickle(), (Integer)0, (this.getDamage() & 3) + 1)};
    }
}

