/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockSeagrass
extends BlockFlowable {
    @PowerNukkitOnly
    public BlockSeagrass() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockSeagrass(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 385;
    }

    @Override
    public String getName() {
        return "Seagrass";
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        int waterDamage;
        Block down = this.down();
        Block layer1Block = block.getLevelBlockAtLayer(1);
        if (down.isSolid() && down.getId() != 213 && down.getId() != 88 && layer1Block instanceof BlockWater && ((waterDamage = block.getDamage()) == 0 || waterDamage == 8)) {
            if (waterDamage == 8) {
                this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
            }
            this.getLevel().setBlock(this, 0, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            int damage;
            Block blockLayer1 = this.getLevelBlockAtLayer(1);
            if (!(blockLayer1 instanceof BlockIceFrosted) && (!(blockLayer1 instanceof BlockWater) || (damage = blockLayer1.getDamage()) != 0 && damage != 8)) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
            Block down = this.down();
            damage = this.getDamage();
            if (damage == 0 || damage == 2) {
                Block up;
                if (!down.isSolid() || down.getId() == 213 || down.getId() == 88) {
                    this.getLevel().useBreakOn(this);
                    return 1;
                }
                if (damage == 2 && ((up = this.up()).getId() != this.getId() || up.getDamage() != 1)) {
                    this.getLevel().useBreakOn(this);
                }
            } else if (down.getId() != this.getId() || down.getDamage() != 2) {
                this.getLevel().useBreakOn(this);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        int damage;
        Block up;
        if (this.getDamage() == 0 && item.isFertilizer() && (up = this.up()) instanceof BlockWater && ((damage = up.getDamage()) == 0 || damage == 8)) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            this.level.setBlock((Vector3)this, new BlockSeagrass(2), true, false);
            this.level.setBlock(up, 1, up, true, false);
            this.level.setBlock((Vector3)up, 0, new BlockSeagrass(1), true);
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WATER_BLOCK_COLOR;
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockSeagrass(), (Integer)0);
    }
}

