/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.particle.CloudParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayDeque;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockSponge
extends BlockSolidMeta {
    public static final int DRY = 0;
    public static final int WET = 1;
    private static final String[] NAMES = new String[]{"Sponge", "Wet sponge"};

    public BlockSponge() {
        this(0);
    }

    public BlockSponge(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public int getToolType() {
        return 6;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 1];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.YELLOW_BLOCK_COLOR;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.getDamage() == 1 && this.level.getDimension() == 1) {
            this.level.setBlock((Vector3)block, Block.get(19, 0), true, true);
            this.getLevel().addLevelEvent(block.add(0.5, 0.875, 0.5), 3501);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < 8; ++i) {
                this.level.addParticle(new CloudParticle(block.getLocation().add(random.nextDouble(), 1.0, random.nextDouble())));
            }
            return true;
        }
        if (this.getDamage() == 0 && block instanceof BlockWater && this.performWaterAbsorb(block)) {
            this.level.setBlock((Vector3)block, Block.get(19, 1), true, true);
            for (int i = 0; i < 4; ++i) {
                LevelEventPacket packet = new LevelEventPacket();
                packet.evid = 2001;
                packet.x = (float)block.getX() + 0.5f;
                packet.y = (float)block.getY() + 1.0f;
                packet.z = (float)block.getZ() + 0.5f;
                packet.data = GlobalBlockPalette.getOrCreateRuntimeId(8, 0);
                this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), packet);
            }
            return true;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    private boolean performWaterAbsorb(Block block) {
        Entry entry;
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>();
        entries.add(new Entry(block, 0));
        int waterRemoved = 0;
        while (waterRemoved < 64 && (entry = (Entry)entries.poll()) != null) {
            for (BlockFace face : BlockFace.values()) {
                Block faceBlock = entry.block.getSide(face);
                if (faceBlock.getId() == 8 || faceBlock.getId() == 9) {
                    this.level.setBlock(faceBlock, Block.get(0));
                    ++waterRemoved;
                    if (entry.distance >= 6) continue;
                    entries.add(new Entry(faceBlock, entry.distance + 1));
                    continue;
                }
                if (faceBlock.getId() != 0 || entry.distance >= 6) continue;
                entries.add(new Entry(faceBlock, entry.distance + 1));
            }
        }
        return waterRemoved > 0;
    }

    private static class Entry {
        private final Block block;
        private final int distance;

        public Entry(Block block, int distance) {
            this.block = block;
            this.distance = distance;
        }
    }
}

