/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.value.StructureBlockType;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@Since(value="1.4.0.0-PN")
@PowerNukkitOnly
public class BlockStructure
extends BlockSolidMeta {
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public static final BlockProperty<StructureBlockType> STRUCTURE_BLOCK_TYPE = new ArrayBlockProperty<StructureBlockType>("structure_block_type", true, StructureBlockType.class);
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public static final BlockProperties PROPERTIES = new BlockProperties(STRUCTURE_BLOCK_TYPE);

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStructure() {
        this(0);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStructure(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 252;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public StructureBlockType getStructureBlockType() {
        return this.getPropertyValue(STRUCTURE_BLOCK_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setStructureBlockType(StructureBlockType type) {
        this.setPropertyValue(STRUCTURE_BLOCK_TYPE, type);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player == null || !player.isCreative() || player.isOp()) {
            // empty if block
        }
        return true;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!(player == null || player.isCreative() && player.isOp())) {
            return false;
        }
        this.getLevel().setBlock((Vector3)block, this, true);
        return true;
    }

    @Override
    public String getName() {
        return this.getStructureBlockType().getEnglishName();
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public double getResistance() {
        return 1.8E7;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.LIGHT_GRAY_BLOCK_COLOR;
    }
}

