/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDoublePlant;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockSweetBerryBush;
import cn.nukkit.blockproperty.value.DoublePlantType;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockTallGrass
extends BlockFlowable {
    public BlockTallGrass() {
        this(1);
    }

    public BlockTallGrass(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 31;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Grass", "Grass", "Fern", "Fern"};
        return names[this.getDamage() & 3];
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public int getBurnChance() {
        return 60;
    }

    @Override
    public int getBurnAbility() {
        return 100;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (BlockSweetBerryBush.isSupportValid(this.down())) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will break on block update if the supporting block is invalid")
    public int onUpdate(int type) {
        if (type == 1 && !BlockSweetBerryBush.isSupportValid(this.down(1, 0))) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            Block up = this.up();
            if (up.getId() == 0) {
                DoublePlantType type;
                switch (this.getDamage()) {
                    case 0: 
                    case 1: {
                        type = DoublePlantType.TALL_GRASS;
                        break;
                    }
                    case 2: 
                    case 3: {
                        type = DoublePlantType.LARGE_FERN;
                        break;
                    }
                    default: {
                        type = null;
                    }
                }
                if (type != null) {
                    if (player != null && !player.isCreative()) {
                        --item.count;
                    }
                    BlockDoublePlant doublePlant = (BlockDoublePlant)Block.get(175);
                    doublePlant.setDoublePlantType(type);
                    doublePlant.setTopHalf(false);
                    this.level.addParticle(new BoneMealParticle(this));
                    this.level.setBlock((Vector3)this, doublePlant, true, false);
                    doublePlant.setTopHalf(true);
                    this.level.setBlock((Vector3)up, doublePlant, true);
                    this.level.updateAround(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        ThreadLocalRandom random;
        ArrayList<Item> drops = new ArrayList<Item>(2);
        if (item.isShears()) {
            drops.add(this.getCurrentState().asItemBlock());
        }
        if ((random = ThreadLocalRandom.current()).nextInt(8) == 0) {
            Enchantment fortune = item.getEnchantment(18);
            int fortuneLevel = fortune != null ? fortune.getLevel() : 0;
            int amount = fortuneLevel == 0 ? 1 : 1 + random.nextInt(fortuneLevel * 2);
            drops.add(Item.get(295, 0, amount));
        }
        return drops.toArray(Item.EMPTY_ARRAY);
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

