/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public class BlockTrapdoor
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable {
    private static final double THICKNESS = 0.1875;
    private static final List<Location> manualOverrides = new ArrayList<Location>();
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<BlockFace> TRAPDOOR_DIRECTION = new ArrayBlockProperty("direction", false, (Serializable[])new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(TRAPDOOR_DIRECTION, BlockStairs.UPSIDE_DOWN, CommonBlockProperties.OPEN);
    private static final AxisAlignedBB[] boundingBoxDamage = new AxisAlignedBB[1 << PROPERTIES.getBitSize()];
    @Deprecated
    @DeprecationDetails(reason="Use the properties or the accessors", since="1.4.0.0-PN", replaceWith="CommonBlockProperties.OPEN")
    public static final int TRAPDOOR_OPEN_BIT = 8;
    @Deprecated
    @DeprecationDetails(reason="Use the properties or the accessors", since="1.4.0.0-PN", replaceWith="BlockStairs.UPSIDE_DOWN")
    public static final int TRAPDOOR_TOP_BIT = 4;

    public BlockTrapdoor() {
        this(0);
    }

    public BlockTrapdoor(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 96;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Oak Trapdoor";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @PowerNukkitDifference(info="The bounding box was fixed", since="1.3.0.0-PN")
    private AxisAlignedBB getRelativeBoundingBox() {
        int bigDamage = this.getSignedBigDamage();
        return boundingBoxDamage[bigDamage];
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    @Override
    @PowerNukkitDifference(info="Checking if the door was opened/closed manually and using new powered checks.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 6 && this.level.getServer().isRedstoneEnabled()) {
            if (this.isOpen() != this.isGettingPower() && !this.getManualOverride()) {
                if (this.isOpen() != this.isGettingPower()) {
                    this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                    this.setOpen(null, this.isGettingPower());
                }
            } else if (this.getManualOverride() && this.isGettingPower() == this.isOpen()) {
                this.setManualOverride(false);
            }
            return type;
        }
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setManualOverride(boolean val) {
        if (val) {
            manualOverrides.add(this.getLocation());
        } else {
            manualOverrides.remove(this.getLocation());
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getManualOverride() {
        return manualOverrides.contains(this.getLocation());
    }

    @Override
    public boolean onBreak(Item item) {
        this.setManualOverride(false);
        return super.onBreak(item);
    }

    @Override
    @PowerNukkitDifference(info="Will return false if setBlock fails and the direction is relative to where the player is facing", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (face.getAxis().isHorizontal()) {
            this.setBlockFace(player == null ? face : player.getDirection().getOpposite());
            this.setTop(fy > 0.5);
        } else {
            this.setBlockFace(player.getDirection().getOpposite());
            this.setTop(face != BlockFace.UP);
        }
        if (!this.getLevel().setBlock((Vector3)block, this, true, true)) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled() && !this.isOpen() && this.isGettingPower()) {
            this.setOpen(null, true);
        }
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        return this.toggle(player);
    }

    @PowerNukkitDifference(info="Just call the #setOpen() method.", since="1.4.0.0-PN")
    public boolean toggle(Player player) {
        return this.setOpen(player, !this.isOpen());
    }

    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Returns false if setBlock fails", since="1.4.0.0-PN"), @PowerNukkitDifference(info="Using direct values, instead of toggling (fixes a redstone bug, that the door won't open). Also adding possibility to detect, whether a player or redstone recently opened/closed the door.", since="1.4.0.0-PN")})
    @PowerNukkitOnly
    public boolean setOpen(Player player, boolean open) {
        if (open == this.isOpen()) {
            return false;
        }
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        player = event.getPlayer();
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
        if (!this.level.setBlock((Vector3)this, this, true, true)) {
            return false;
        }
        if (player != null) {
            this.setManualOverride(this.isGettingPower() || this.isOpen());
        }
        this.playOpenCloseSound();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenCloseSound() {
        if (this.isOpen()) {
            this.playOpenSound();
        } else {
            this.playCloseSound();
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playCloseSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public boolean isOpen() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOpen(boolean open) {
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
    }

    public boolean isTop() {
        return this.getBooleanValue(BlockStairs.UPSIDE_DOWN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTop(boolean top) {
        this.setBooleanValue(BlockStairs.UPSIDE_DOWN, top);
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getPropertyValue(TRAPDOOR_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(TRAPDOOR_DIRECTION, face);
    }

    static {
        for (int damage = 0; damage < boundingBoxDamage.length; ++damage) {
            SimpleAxisAlignedBB bb;
            if (PROPERTIES.getBooleanValue(damage, CommonBlockProperties.OPEN.getName())) {
                BlockFace face = (BlockFace)((Object)PROPERTIES.getValue(damage, TRAPDOOR_DIRECTION.getName()));
                bb = (face = face.getOpposite()).getAxisDirection() == BlockFace.AxisDirection.NEGATIVE ? new SimpleAxisAlignedBB(0.0, 0.0, 0.0, (double)(1 + face.getXOffset()) - 0.1875 * (double)face.getXOffset(), 1.0, (double)(1 + face.getZOffset()) - 0.1875 * (double)face.getZOffset()) : new SimpleAxisAlignedBB((double)face.getXOffset() - 0.1875 * (double)face.getXOffset(), 0.0, (double)face.getZOffset() - 0.1875 * (double)face.getZOffset(), 1.0, 1.0, 1.0);
            } else {
                bb = PROPERTIES.getBooleanValue(damage, BlockStairs.UPSIDE_DOWN.getName()) ? new SimpleAxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0) : new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
            }
            BlockTrapdoor.boundingBoxDamage[damage] = bb;
        }
    }
}

