/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.utils.BlockColor;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Extends BlockWallBase and implements BlockConnectable only on PowerNukkit", since="1.4.0.0-PN")
public class BlockWall
extends BlockWallBase {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<WallType> WALL_BLOCK_TYPE = new ArrayBlockProperty<WallType>("wall_block_type", true, WallType.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(WALL_BLOCK_TYPE, WALL_CONNECTION_TYPE_SOUTH, WALL_CONNECTION_TYPE_WEST, WALL_CONNECTION_TYPE_NORTH, WALL_CONNECTION_TYPE_EAST, WALL_POST_BIT);
    @Deprecated
    @DeprecationDetails(reason="No longer matches the meta directly", replaceWith="WallType.COBBLESTONE", since="1.3.0.0-PN")
    public static final int NONE_MOSSY_WALL = 0;
    @Deprecated
    @DeprecationDetails(reason="No longer matches the meta directly", replaceWith="WallType.MOSSY_COBBLESTONE", since="1.3.0.0-PN")
    public static final int MOSSY_WALL = 1;

    public BlockWall() {
        this(0);
    }

    public BlockWall(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 139;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @PowerNukkitDifference(since="1.3.0.0-PN", info="Return the actual material color instead of transparent")
    public BlockColor getColor() {
        return this.getWallType().color;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public WallType getWallType() {
        return this.getPropertyValue(WALL_BLOCK_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setWallType(WallType type) {
        this.setPropertyValue(WALL_BLOCK_TYPE, type);
    }

    @Override
    public String getName() {
        return this.getWallType().getTypeName();
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public static enum WallType {
        COBBLESTONE,
        MOSSY_COBBLESTONE,
        GRANITE(BlockColor.DIRT_BLOCK_COLOR),
        DIORITE(BlockColor.QUARTZ_BLOCK_COLOR),
        ANDESITE,
        SANDSTONE(BlockColor.SAND_BLOCK_COLOR),
        BRICK(BlockColor.RED_BLOCK_COLOR),
        STONE_BRICK,
        MOSSY_STONE_BRICK,
        NETHER_BRICK(BlockColor.NETHERRACK_BLOCK_COLOR),
        END_STONE_BRICK(BlockColor.SAND_BLOCK_COLOR),
        PRISMARINE(BlockColor.CYAN_BLOCK_COLOR),
        RED_SANDSTONE(BlockColor.ORANGE_BLOCK_COLOR),
        RED_NETHER_BRICK(BlockColor.NETHERRACK_BLOCK_COLOR);

        private final BlockColor color;
        private final String typeName;

        private WallType(BlockColor color) {
            this.color = color;
            String name = Arrays.stream(this.name().split("_")).map(part -> part.substring(0, 1) + part.substring(1).toLowerCase()).collect(Collectors.joining(" "));
            this.typeName = name + " Wall";
        }

        private WallType() {
            this(BlockColor.STONE_BLOCK_COLOR);
        }

        @Since(value="1.3.0.0-PN")
        public BlockColor getColor() {
            return this.color;
        }

        @Since(value="1.4.0.0-PN")
        public String getTypeName() {
            return this.typeName;
        }
    }

    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public static enum WallConnectionType {
        NONE,
        SHORT,
        TALL;

    }
}

