/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.BlockAir;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.utils.RedstoneComponent;

public class BlockEntityLectern
extends BlockEntitySpawnable {
    private int totalPages;

    public BlockEntityLectern(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!(this.namedTag.get("book") instanceof CompoundTag)) {
            this.namedTag.remove("book");
        }
        if (!(this.namedTag.get("page") instanceof IntTag)) {
            this.namedTag.remove("page");
        }
        this.updateTotalPages();
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Lectern").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putBoolean("isMovable", this.movable);
        Item book = this.getBook();
        if (book.getId() != 0) {
            c.putCompound("book", NBTIO.putItemHelper(book));
            c.putBoolean("hasBook", true);
            c.putInt("page", this.getRawPage());
            c.putInt("totalPages", this.totalPages);
        } else {
            c.putBoolean("hasBook", false);
        }
        return c;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 449;
    }

    @Override
    public void onBreak() {
        this.level.dropItem(this, this.getBook());
    }

    public boolean hasBook() {
        return this.namedTag.contains("book") && this.namedTag.get("book") instanceof CompoundTag;
    }

    public Item getBook() {
        if (!this.hasBook()) {
            return new ItemBlock(new BlockAir(), (Integer)0, 0);
        }
        return NBTIO.getItemHelper(this.namedTag.getCompound("book"));
    }

    public void setBook(Item item) {
        if (item.getId() == 387 || item.getId() == 386) {
            this.namedTag.putCompound("book", NBTIO.putItemHelper(item));
        } else {
            this.namedTag.remove("book");
            this.namedTag.remove("page");
        }
        this.updateTotalPages();
    }

    public int getLeftPage() {
        return this.getRawPage() * 2 + 1;
    }

    public int getRightPage() {
        return this.getLeftPage() + 1;
    }

    public void setLeftPage(int newLeftPage) {
        this.setRawPage((newLeftPage - 1) / 2);
    }

    public void setRightPage(int newRightPage) {
        this.setLeftPage(newRightPage - 1);
    }

    public void setRawPage(int page) {
        this.namedTag.putInt("page", Math.min(page, this.totalPages));
        this.getLevel().updateAround(this);
    }

    public int getRawPage() {
        return this.namedTag.getInt("page");
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    @PowerNukkitDifference(info="Use RedstoneComponent for redstone update.", since="1.4.0.0-PN")
    private void updateTotalPages() {
        Item book = this.getBook();
        this.totalPages = book.getId() == 0 || !book.hasCompoundTag() ? 0 : book.getNamedTag().getList("pages", CompoundTag.class).size();
        RedstoneComponent.updateAroundRedstone((Position)this, new BlockFace[0]);
    }
}

