/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.exception;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class InvalidBlockPropertyValueException
extends InvalidBlockPropertyException {
    private static final long serialVersionUID = -1087431932428639175L;
    @Nullable
    private final Serializable currentValue;
    @Nullable
    private final Serializable invalidValue;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue));
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, String message) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue) + ". " + message);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, String message, Throwable cause) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue) + ". " + message, cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, Throwable cause) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue), cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    private static String buildMessage(Object currentValue, Object invalidValue) {
        return "Current Value: " + currentValue + ", Invalid Value: " + invalidValue;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getInvalidValue() {
        return this.invalidValue;
    }
}

