/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.value;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public enum StoneSlab4Type {
    MOSSY_STONE_BRICK(BlockColor.STONE_BLOCK_COLOR),
    SMOOTH_QUARTZ(BlockColor.QUARTZ_BLOCK_COLOR),
    STONE(BlockColor.STONE_BLOCK_COLOR),
    CUT_SANDSTONE(BlockColor.SAND_BLOCK_COLOR),
    CUT_RED_SANDSTONE(BlockColor.ORANGE_BLOCK_COLOR);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<StoneSlab4Type> PROPERTY;
    private final BlockColor color;
    private final String englishName;

    private StoneSlab4Type(BlockColor color) {
        this.color = color;
        this.englishName = Arrays.stream(this.name().split("_")).map(name -> name.substring(0, 1) + name.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockColor getColor() {
        return this.color;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getEnglishName() {
        return this.englishName;
    }

    static {
        PROPERTY = new ArrayBlockProperty("stone_slab_type_4", true, (Serializable[])StoneSlab4Type.values());
    }
}

