/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.data;

import cn.nukkit.api.Since;
import cn.nukkit.block.BlockID;
import cn.nukkit.item.MinecraftItemID;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class CommandEnum {
    @Since(value="1.4.0.0-PN")
    public static final CommandEnum ENUM_BOOLEAN = new CommandEnum("Boolean", (List<String>)ImmutableList.of((Object)"true", (Object)"false"));
    @Since(value="1.4.0.0-PN")
    public static final CommandEnum ENUM_GAMEMODE = new CommandEnum("GameMode", (List<String>)ImmutableList.of((Object)"survival", (Object)"creative", (Object)"s", (Object)"c", (Object)"adventure", (Object)"a", (Object)"spectator", (Object)"view", (Object)"v", (Object)"spc"));
    @Since(value="1.4.0.0-PN")
    public static final CommandEnum ENUM_BLOCK;
    @Since(value="1.4.0.0-PN")
    public static final CommandEnum ENUM_ITEM;
    private String name;
    private List<String> values;

    @Since(value="1.4.0.0-PN")
    public CommandEnum(String name, String ... values) {
        this(name, Arrays.asList(values));
    }

    public CommandEnum(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (Field field : BlockID.class.getDeclaredFields()) {
            blocks.add((Object)field.getName().toLowerCase());
        }
        ENUM_BLOCK = new CommandEnum("Block", (List<String>)blocks.build());
        ENUM_ITEM = new CommandEnum("Item", (List<String>)ImmutableList.copyOf((Object[])Arrays.stream(MinecraftItemID.values()).filter(it -> !it.isTechnical()).filter(it -> !it.isEducationEdition()).flatMap(it -> Stream.of(Stream.of(it.getNamespacedId())).flatMap(Function.identity())).map(it -> it.substring(10).toLowerCase()).toArray(String[]::new)));
    }
}

