/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class ProjectileDispenseBehavior
extends DefaultDispenseBehavior {
    private final String entityType;

    public ProjectileDispenseBehavior(String entity) {
        this.entityType = entity;
    }

    @Override
    @PowerNukkitDifference(info="Implement sound.", since="1.4.0.0-PN")
    public Item dispense(BlockDispenser source, BlockFace face, Item item) {
        Vector3 dispensePos = source.getDispensePosition();
        CompoundTag nbt = Entity.getDefaultNBT(dispensePos);
        this.correctNBT(nbt);
        Entity projectile = Entity.createEntity(this.getEntityType(), (FullChunk)source.level.getChunk(dispensePos.getChunkX(), dispensePos.getChunkZ()), nbt, new Object[0]);
        if (!(projectile instanceof EntityProjectile)) {
            return super.dispense(source, face, item);
        }
        Vector3 motion = new Vector3(face.getXOffset(), (float)face.getYOffset() + 0.1f, face.getZOffset()).normalize();
        projectile.setMotion(motion);
        ((EntityProjectile)projectile).inaccurate(this.getAccuracy());
        projectile.setMotion(projectile.getMotion().multiply(this.getMotion()));
        ((EntityProjectile)projectile).updateRotation();
        projectile.spawnToAll();
        source.level.addSound(source, Sound.RANDOM_BOW);
        return null;
    }

    protected double getMotion() {
        return 1.1;
    }

    protected float getAccuracy() {
        return 6.0f;
    }

    protected String getEntityType() {
        return this.entityType;
    }

    protected void correctNBT(CompoundTag nbt) {
    }
}

