/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.EntityNameable;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.EntityArmorInventory;
import cn.nukkit.inventory.EntityEquipmentInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import java.util.Collection;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class EntityArmorStand
extends Entity
implements InventoryHolder,
EntityInteractable,
EntityNameable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int NETWORK_ID = 61;
    private static final String TAG_MAINHAND = "Mainhand";
    private static final String TAG_POSE_INDEX = "PoseIndex";
    private static final String TAG_OFFHAND = "Offhand";
    private static final String TAG_ARMOR = "Armor";
    private EntityEquipmentInventory equipmentInventory;
    private EntityArmorInventory armorInventory;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityArmorStand(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.setMaxHealth(6);
        this.setHealth(6.0f);
        if (nbt.contains(TAG_POSE_INDEX)) {
            this.setPose(nbt.getInt(TAG_POSE_INDEX));
        }
    }

    private static int getArmorSlot(ItemArmor armorItem) {
        if (armorItem.isHelmet()) {
            return 0;
        }
        if (armorItem.isChestplate()) {
            return 1;
        }
        if (armorItem.isLeggings()) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getNetworkId() {
        return 61;
    }

    @Override
    public float getHeight() {
        return 1.975f;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected void initEntity() {
        this.setHealth(6.0f);
        this.setMaxHealth(6);
        this.setImmobile(true);
        super.initEntity();
        this.equipmentInventory = new EntityEquipmentInventory(this);
        this.armorInventory = new EntityArmorInventory(this);
        if (this.namedTag.contains(TAG_MAINHAND)) {
            this.equipmentInventory.setItemInHand(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_MAINHAND)), true);
        }
        if (this.namedTag.contains(TAG_OFFHAND)) {
            this.equipmentInventory.setItemInOffhand(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_OFFHAND)), true);
        }
        if (this.namedTag.contains(TAG_ARMOR)) {
            ListTag<CompoundTag> armorList = this.namedTag.getList(TAG_ARMOR, CompoundTag.class);
            for (CompoundTag armorTag : armorList.getAll()) {
                this.armorInventory.setItem(armorTag.getByte("Slot"), NBTIO.getItemHelper(armorTag));
            }
        }
        if (this.namedTag.contains(TAG_POSE_INDEX)) {
            this.setPose(this.namedTag.getInt(TAG_POSE_INDEX));
        }
    }

    @Override
    @PowerNukkitOnly
    public boolean isPersistent() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public void setPersistent(boolean persistent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        int slot;
        boolean isArmor;
        boolean hasItemInHand;
        if (player.isSpectator() || !this.isValid()) {
            return false;
        }
        if (!item.isNull() && item.getId() == 421 && this.playerApplyNameTag(player, item, false)) {
            return true;
        }
        if (player.isSneaking()) {
            if (this.getPose() >= 12) {
                this.setPose(0);
                return false;
            } else {
                this.setPose(this.getPose() + 1);
            }
            return false;
        }
        boolean bl = hasItemInHand = !item.isNull();
        if (hasItemInHand && item instanceof ItemArmor) {
            ItemArmor itemArmor = (ItemArmor)item;
            isArmor = true;
            slot = EntityArmorStand.getArmorSlot(itemArmor);
        } else if (hasItemInHand && item.getId() == 397 || item.getBlockId() == 410) {
            isArmor = true;
            slot = 0;
        } else if (hasItemInHand) {
            isArmor = false;
            slot = item.getId() == 513 ? 1 : 0;
        } else {
            double clickHeight = clickedPos.y - this.y;
            if (clickHeight >= 0.1 && clickHeight < 0.55 && !this.armorInventory.getBoots().isNull()) {
                isArmor = true;
                slot = 3;
            } else if (clickHeight >= 0.9 && clickHeight < 1.6) {
                if (!this.equipmentInventory.getItemInOffhand().isNull()) {
                    isArmor = false;
                    slot = 1;
                } else if (!this.equipmentInventory.getItemInHand().isNull()) {
                    isArmor = false;
                    slot = 0;
                } else {
                    if (this.armorInventory.getChestplate().isNull()) return false;
                    isArmor = true;
                    slot = 1;
                }
            } else if (clickHeight >= 0.4 && clickHeight < 1.2 && !this.armorInventory.getLeggings().isNull()) {
                isArmor = true;
                slot = 2;
            } else if (clickHeight >= 1.6 && !this.armorInventory.getHelmet().isNull()) {
                isArmor = true;
                slot = 0;
            } else if (!this.equipmentInventory.getItemInOffhand().isNull()) {
                isArmor = false;
                slot = 1;
            } else {
                if (this.equipmentInventory.getItemInHand().isNull()) return false;
                isArmor = false;
                slot = 0;
            }
        }
        boolean changed = false;
        if (isArmor) {
            changed = this.tryChangeEquipment(player, item, slot, true);
            slot = 0;
        }
        if (!changed) {
            changed = this.tryChangeEquipment(player, item, slot, false);
        }
        if (!changed) return false;
        this.level.addSound(this, Sound.MOB_ARMOR_STAND_PLACE);
        return false;
    }

    private boolean tryChangeEquipment(Player player, Item handItem, int slot, boolean isArmorSlot) {
        BaseInventory inventory = isArmorSlot ? this.armorInventory : this.equipmentInventory;
        Item item = inventory.getItem(slot);
        if (item.isNull() && !handItem.isNull()) {
            Item itemClone = handItem.clone();
            itemClone.setCount(1);
            inventory.setItem(slot, itemClone);
            if (!player.isCreative()) {
                --handItem.count;
                player.getInventory().setItem(player.getInventory().getHeldItemIndex(), handItem);
            }
            return true;
        }
        if (!item.isNull()) {
            Item[] notAdded;
            Item itemtoAddToArmorStand = Item.getBlock(0);
            if (!handItem.isNull()) {
                Item itemToSetToPlayerInv;
                if (handItem.equals(item, true, true)) {
                    return false;
                }
                if (item.count > 1) {
                    return false;
                }
                if (handItem.count > 1) {
                    itemtoAddToArmorStand = handItem.clone();
                    itemtoAddToArmorStand.setCount(1);
                    itemToSetToPlayerInv = handItem.clone();
                    --itemToSetToPlayerInv.count;
                } else {
                    itemtoAddToArmorStand = handItem.clone();
                    itemToSetToPlayerInv = Item.getBlock(0);
                }
                player.getInventory().setItem(player.getInventory().getHeldItemIndex(), itemToSetToPlayerInv);
            }
            if ((notAdded = player.getInventory().addItem(item)).length > 0) {
                if (notAdded[0].count == item.count) {
                    if (!handItem.isNull()) {
                        player.getInventory().setItem(player.getInventory().getHeldItemIndex(), handItem);
                    }
                    return false;
                }
                Item itemClone = item.clone();
                itemClone.count -= notAdded[0].count;
                inventory.setItem(slot, itemClone);
            } else {
                inventory.setItem(slot, itemtoAddToArmorStand);
            }
            return true;
        }
        return false;
    }

    private int getPose() {
        return this.dataProperties.getInt(Entity.DATA_ARMOR_STAND_POSE_INDEX);
    }

    private void setPose(int pose) {
        this.dataProperties.putInt(Entity.DATA_ARMOR_STAND_POSE_INDEX, pose);
        SetEntityDataPacket setEntityDataPacket = new SetEntityDataPacket();
        setEntityDataPacket.eid = this.getId();
        setEntityDataPacket.metadata = this.getDataProperties();
        Server.getInstance().getOnlinePlayers().values().forEach(all -> all.dataPacket(setEntityDataPacket));
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put(TAG_MAINHAND, NBTIO.putItemHelper(this.equipmentInventory.getItemInHand()));
        this.namedTag.put(TAG_OFFHAND, NBTIO.putItemHelper(this.equipmentInventory.getItemInOffhand()));
        if (this.armorInventory != null) {
            ListTag<CompoundTag> armorTag = new ListTag<CompoundTag>(TAG_ARMOR);
            for (int i = 0; i < 4; ++i) {
                armorTag.add(NBTIO.putItemHelper(this.armorInventory.getItem(i), i));
            }
            this.namedTag.putList(armorTag);
        }
        this.namedTag.putInt(TAG_POSE_INDEX, this.getPose());
    }

    @Override
    public void spawnTo(Player player) {
        super.spawnTo(player);
        this.equipmentInventory.sendContents(player);
        this.armorInventory.sendContents(player);
    }

    @Override
    public void spawnToAll() {
        if (this.chunk != null && !this.closed) {
            Collection<Player> chunkPlayers = this.level.getChunkPlayers(this.chunk.getX(), this.chunk.getZ()).values();
            for (Player chunkPlayer : chunkPlayers) {
                this.spawnTo(chunkPlayer);
            }
        }
    }

    @Override
    public void fall(float fallDistance) {
        super.fall(fallDistance);
        this.getLevel().addSound(this, Sound.MOB_ARMOR_STAND_LAND);
    }

    @Override
    public void kill() {
        super.kill();
        EntityDamageEvent lastDamageCause = this.lastDamageCause;
        boolean byAttack = lastDamageCause != null && lastDamageCause.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK;
        Position pos = this.getPosition();
        pos.y += 0.2;
        this.level.dropItem(pos, this.armorInventory.getBoots());
        pos.y = this.y + 0.6;
        this.level.dropItem(pos, this.armorInventory.getLeggings());
        pos.y = this.y + 1.4;
        this.level.dropItem(byAttack ? pos : this, Item.get(425));
        this.level.dropItem(pos, this.armorInventory.getChestplate());
        this.equipmentInventory.getContents().values().forEach(items -> this.level.dropItem(this, (Item)items));
        this.equipmentInventory.clearAll();
        pos.y = this.y + 1.8;
        this.level.dropItem(pos, this.armorInventory.getHelmet());
        this.armorInventory.clearAll();
        this.level.addSound(this, Sound.MOB_ARMOR_STAND_BREAK);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        Player player;
        EntityDamageByEntityEvent event;
        switch (source.getCause()) {
            case FALL: {
                source.setCancelled(true);
                this.level.addSound(this, Sound.MOB_ARMOR_STAND_LAND);
                break;
            }
            case CONTACT: 
            case HUNGER: 
            case MAGIC: 
            case DROWNING: 
            case SUFFOCATION: 
            case PROJECTILE: {
                source.setCancelled(true);
                break;
            }
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: {
                if (!this.hasEffect(12)) break;
                return false;
            }
        }
        if (source.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            if (this.namedTag.getByte("InvulnerableTimer") > 0) {
                source.setCancelled(true);
            }
            if (super.attack(source)) {
                this.namedTag.putByte("InvulnerableTimer", 9);
                return true;
            }
            return false;
        }
        this.getServer().getPluginManager().callEvent(source);
        if (source.isCancelled()) {
            return false;
        }
        this.setLastDamageCause(source);
        if (this.getDataPropertyInt(DATA_HURT_TIME) > 0) {
            this.setHealth(0.0f);
            return true;
        }
        if (source instanceof EntityDamageByEntityEvent && (event = (EntityDamageByEntityEvent)source).getDamager() instanceof Player && (player = (Player)event.getDamager()).isCreative()) {
            this.level.addParticle(new DestroyBlockParticle(this, Block.get(5)));
            this.close();
            return true;
        }
        this.setDataProperty(new IntEntityData(DATA_HURT_TIME, 9), true);
        this.level.addSound(this, Sound.MOB_ARMOR_STAND_HIT);
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hasCustomName() ? this.getNameTag() : "Armor Stand";
    }

    @Override
    public boolean entityBaseTick(int tickDiff) {
        boolean hasUpdate = super.entityBaseTick(tickDiff);
        int hurtTime = this.getDataPropertyInt(DATA_HURT_TIME);
        if (hurtTime > 0 && this.age % 2 == 0) {
            this.setDataProperty(new IntEntityData(DATA_HURT_TIME, hurtTime - 1), true);
            hasUpdate = true;
        }
        if ((hurtTime = this.namedTag.getByte("InvulnerableTimer")) > 0 && this.age % 2 == 0) {
            this.namedTag.putByte("InvulnerableTimer", hurtTime - 1);
        }
        return hasUpdate;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityEquipmentInventory getEquipmentInventory() {
        return this.equipmentInventory;
    }

    @Override
    public EntityArmorInventory getInventory() {
        return this.armorInventory;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        int tickDiff = currentTick - this.lastUpdate;
        boolean hasUpdated = super.onUpdate(currentTick);
        if (this.closed || tickDiff <= 0 && !this.justCreated) {
            return hasUpdated;
        }
        this.timing.startTiming();
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            if (this.getHealth() < (float)this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 0.001f);
            }
            this.motionY -= (double)this.getGravity();
            double highestPosition = this.highestPosition;
            this.move(this.motionX, this.motionY, this.motionZ);
            float friction = 1.0f - this.getDrag();
            this.motionX *= (double)friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= (double)friction;
            this.updateMovement();
            hasUpdate = true;
            if (this.onGround && highestPosition - this.y >= 3.0) {
                this.level.addSound(this, Sound.MOB_ARMOR_STAND_LAND);
            }
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    protected float getDrag() {
        if (this.hasWaterAt(this.getHeight() / 2.0f)) {
            return 0.25f;
        }
        return 0.0f;
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.armorstand.equip";
    }

    @Override
    public boolean canDoInteraction() {
        return true;
    }
}

