/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.randomitem.Fishing;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.BubbleParticle;
import cn.nukkit.level.particle.WaterParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import java.util.Random;

public class EntityFishingHook
extends EntityProjectile {
    public static final int NETWORK_ID = 77;
    public static final int WAIT_CHANCE = 120;
    public static final int CHANCE = 40;
    public boolean chance = false;
    public int waitChance = 240;
    public boolean attracted = false;
    public int attractTimer = 0;
    public boolean caught = false;
    public int coughtTimer = 0;
    public Vector3 fish = null;
    public Item rod = null;

    public EntityFishingHook(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityFishingHook(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.age > 0) {
            this.close();
        }
    }

    @Override
    public int getNetworkId() {
        return 77;
    }

    @Override
    public float getWidth() {
        return 0.2f;
    }

    @Override
    public float getLength() {
        return 0.2f;
    }

    @Override
    public float getHeight() {
        return 0.2f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public float getDrag() {
        return 0.04f;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        boolean hasUpdate = false;
        long target = this.getDataPropertyLong(DATA_TARGET_EID);
        if (target != 0L) {
            Entity entity = this.getLevel().getEntity(target);
            if (entity == null || !entity.isAlive()) {
                this.setDataProperty(new LongEntityData(DATA_TARGET_EID, 0L));
            } else {
                Vector3f offset = entity.getMountedOffset(this);
                this.setPosition(new Vector3(entity.x + (double)offset.x, entity.y + (double)offset.y, entity.z + (double)offset.z));
            }
            hasUpdate = true;
        }
        if (hasUpdate |= super.onUpdate(currentTick)) {
            return false;
        }
        if (this.isInsideOfWater()) {
            this.motionX = 0.0;
            this.motionY -= (double)this.getGravity() * -0.04;
            this.motionZ = 0.0;
            hasUpdate = true;
        } else if (this.isCollided && this.keepMovement) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.keepMovement = false;
            hasUpdate = true;
        }
        Random random = new Random();
        if (this.isInsideOfWater()) {
            if (!this.attracted) {
                if (this.waitChance > 0) {
                    --this.waitChance;
                }
                if (this.waitChance == 0) {
                    if (random.nextInt(100) < 90) {
                        this.attractTimer = random.nextInt(40) + 20;
                        this.spawnFish();
                        this.caught = false;
                        this.attracted = true;
                    } else {
                        this.waitChance = 120;
                    }
                }
            } else if (!this.caught) {
                if (this.attractFish()) {
                    this.coughtTimer = random.nextInt(20) + 30;
                    this.fishBites();
                    this.caught = true;
                }
            } else {
                if (this.coughtTimer > 0) {
                    --this.coughtTimer;
                }
                if (this.coughtTimer == 0) {
                    this.attracted = false;
                    this.caught = false;
                    this.waitChance = 360;
                }
            }
        }
        return hasUpdate;
    }

    public int getWaterHeight() {
        for (int y = this.getFloorY(); y < 256; ++y) {
            int id = this.level.getBlockIdAt(this.getFloorX(), y, this.getFloorZ());
            if (id != 0) continue;
            return y;
        }
        return this.getFloorY();
    }

    public void fishBites() {
        EntityEventPacket pk = new EntityEventPacket();
        pk.eid = this.getId();
        pk.event = 13;
        Server.broadcastPacket(this.getViewers().values(), (DataPacket)pk);
        EntityEventPacket bubblePk = new EntityEventPacket();
        bubblePk.eid = this.getId();
        bubblePk.event = 11;
        Server.broadcastPacket(this.getViewers().values(), (DataPacket)bubblePk);
        EntityEventPacket teasePk = new EntityEventPacket();
        teasePk.eid = this.getId();
        teasePk.event = 14;
        Server.broadcastPacket(this.getViewers().values(), (DataPacket)teasePk);
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            this.level.addParticle(new BubbleParticle(this.setComponents(this.x + random.nextDouble() * 0.5 - 0.25, this.getWaterHeight(), this.z + random.nextDouble() * 0.5 - 0.25)));
        }
    }

    public void spawnFish() {
        Random random = new Random();
        this.fish = new Vector3(this.x + (random.nextDouble() * 1.2 + 1.0) * (double)(random.nextBoolean() ? -1 : 1), this.getWaterHeight(), this.z + (random.nextDouble() * 1.2 + 1.0) * (double)(random.nextBoolean() ? -1 : 1));
    }

    public boolean attractFish() {
        double dist;
        double multiply = 0.1;
        this.fish.setComponents(this.fish.x + (this.x - this.fish.x) * multiply, this.fish.y, this.fish.z + (this.z - this.fish.z) * multiply);
        if (new Random().nextInt(100) < 85) {
            this.level.addParticle(new WaterParticle(this.fish));
        }
        return (dist = Math.abs(Math.sqrt(this.x * this.x + this.z * this.z) - Math.sqrt(this.fish.x * this.fish.x + this.fish.z * this.fish.z))) < 0.15;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="May create custom EntityItem")
    public void reelLine() {
        if (this.shootingEntity instanceof Player && this.caught) {
            Vector3 motion;
            Item item = Fishing.getFishingResult(this.rod);
            int experience = new Random().nextInt(3) + 1;
            if (this.shootingEntity != null) {
                motion = this.shootingEntity.subtract(this).multiply(0.1);
                motion.y += Math.sqrt(this.shootingEntity.distance(this)) * 0.08;
            } else {
                motion = new Vector3();
            }
            EntityItem itemEntity = (EntityItem)Entity.createEntity(64, (FullChunk)this.level.getChunk((int)this.x >> 4, (int)this.z >> 4, true), Entity.getDefaultNBT(new Vector3(this.x, this.getWaterHeight(), this.z), motion, new Random().nextFloat() * 360.0f, 0.0f).putCompound("Item", NBTIO.putItemHelper(item)).putShort("Health", 5).putShort("PickupDelay", 1), new Object[0]);
            if (itemEntity != null) {
                if (this.shootingEntity != null && this.shootingEntity instanceof Player) {
                    itemEntity.setOwner(this.shootingEntity.getName());
                }
                itemEntity.spawnToAll();
            }
            Player player = (Player)this.shootingEntity;
            if (experience > 0) {
                player.addExperience(experience);
            }
        }
        if (this.shootingEntity instanceof Player) {
            EntityEventPacket pk = new EntityEventPacket();
            pk.eid = this.getId();
            pk.event = 14;
            Server.broadcastPacket(this.getViewers().values(), (DataPacket)pk);
        }
        if (!this.closed) {
            this.kill();
            this.close();
        }
    }

    @Override
    public void spawnTo(Player player) {
        AddEntityPacket pk = new AddEntityPacket();
        pk.entityRuntimeId = this.getId();
        pk.entityUniqueId = this.getId();
        pk.type = 77;
        pk.x = (float)this.x;
        pk.y = (float)this.y;
        pk.z = (float)this.z;
        pk.speedX = (float)this.motionX;
        pk.speedY = (float)this.motionY;
        pk.speedZ = (float)this.motionZ;
        pk.yaw = (float)this.yaw;
        pk.pitch = (float)this.pitch;
        long ownerId = -1L;
        if (this.shootingEntity != null) {
            ownerId = this.shootingEntity.getId();
        }
        pk.metadata = this.dataProperties.putLong(DATA_OWNER_EID, ownerId);
        player.dataPacket(pk);
        super.spawnTo(player);
    }

    @Override
    public boolean canCollide() {
        return this.getDataPropertyLong(DATA_TARGET_EID) == 0L;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity)));
        float damage = this.getResultDamage();
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage);
        if (entity.attack(ev)) {
            this.setDataProperty(new LongEntityData(DATA_TARGET_EID, entity.getId()));
        }
    }
}

