/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.Position;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

@PowerNukkitOnly
public class GrindstoneInventory
extends FakeBlockUIComponent {
    @PowerNukkitOnly
    public static final int OFFSET = 16;
    private static final int SLOT_FIRST_ITEM = 0;
    private static final int SLOT_SECOND_ITEM = 1;
    private static final int SLOT_RESULT = 34;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int GRINDSTONE_EQUIPMENT_UI_SLOT = 16;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int GRINDSTONE_INGREDIENT_UI_SLOT = 17;
    private int resultExperience;

    @PowerNukkitOnly
    public GrindstoneInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.GRINDSTONE, 16, position);
    }

    @Override
    public void close(Player who) {
        this.onClose(who);
    }

    @Override
    public void onClose(Player who) {
        super.onClose(who);
        who.craftingType = 0;
        Item[] drops = new Item[]{this.getFirstItem(), this.getSecondItem()};
        for (Item drop : drops = who.getInventory().addItem(drops)) {
            if (who.dropItem(drop)) continue;
            this.getHolder().getLevel().dropItem(this.getHolder().add(0.5, 0.5, 0.5), drop);
        }
        this.clear(0);
        this.clear(1);
        who.resetCraftingGridType();
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 1000;
    }

    @PowerNukkitOnly
    public Item getFirstItem() {
        return this.getItem(0);
    }

    @PowerNukkitOnly
    public Item getSecondItem() {
        return this.getItem(1);
    }

    @PowerNukkitOnly
    public Item getResult() {
        return this.getItem(2);
    }

    @PowerNukkitOnly
    public boolean setFirstItem(Item item, boolean send) {
        return this.setItem(0, item, send);
    }

    @PowerNukkitOnly
    public boolean setFirstItem(Item item) {
        return this.setFirstItem(item, true);
    }

    @PowerNukkitOnly
    public boolean setSecondItem(Item item, boolean send) {
        return this.setItem(1, item, send);
    }

    @PowerNukkitOnly
    public boolean setSecondItem(Item item) {
        return this.setSecondItem(item, true);
    }

    @PowerNukkitOnly
    public boolean setResult(Item item, boolean send) {
        return this.setItem(2, item, send);
    }

    @PowerNukkitOnly
    public boolean setResult(Item item) {
        return this.setResult(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        try {
            if (index > 1) {
                return;
            }
            this.updateResult(send);
        }
        finally {
            super.onSlotChange(index, before, send);
        }
    }

    public boolean updateResult(boolean send) {
        Item firstItem = this.getFirstItem();
        Item secondItem = this.getSecondItem();
        if (!firstItem.isNull() && !secondItem.isNull() && firstItem.getId() != secondItem.getId()) {
            this.setResult(Item.get(0), send);
            this.setResultExperience(0);
            return false;
        }
        if (firstItem.isNull()) {
            Item air = firstItem;
            firstItem = secondItem;
            secondItem = air;
        }
        if (firstItem.isNull()) {
            this.setResult(Item.get(0), send);
            this.setResultExperience(0);
            return false;
        }
        if (firstItem.getId() == 403) {
            if (secondItem.isNull()) {
                this.setResult(Item.get(340, 0, firstItem.getCount()), send);
                this.recalculateResultExperience();
            } else {
                this.setResultExperience(0);
                this.setResult(Item.get(0), send);
            }
            return false;
        }
        Item result = firstItem.clone();
        CompoundTag tag = result.getNamedTag();
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.remove("ench");
        result.setCompoundTag(tag);
        if (!secondItem.isNull() && firstItem.getMaxDurability() > 0) {
            int first = firstItem.getMaxDurability() - firstItem.getDamage();
            int second = secondItem.getMaxDurability() - secondItem.getDamage();
            int reduction = first + second + firstItem.getMaxDurability() * 5 / 100;
            int resultingDamage = Math.max(firstItem.getMaxDurability() - reduction + 1, 0);
            result.setDamage(resultingDamage);
        }
        this.setResult(result, send);
        this.recalculateResultExperience();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void recalculateResultExperience() {
        if (this.getResult().isNull()) {
            this.setResultExperience(0);
            return;
        }
        Item firstItem = this.getFirstItem();
        Item secondItem = this.getSecondItem();
        if (!firstItem.hasEnchantments() && !secondItem.hasEnchantments()) {
            this.setResultExperience(0);
            return;
        }
        int resultExperience = Stream.of(firstItem, secondItem).flatMap(item -> {
            if (item.isNull()) {
                return Stream.empty();
            }
            if (item.getCount() == 1) {
                return Arrays.stream(item.getEnchantments());
            }
            Enchantment[][] enchantments = new Enchantment[item.getCount()][];
            Arrays.fill((Object[])enchantments, item.getEnchantments());
            return Arrays.stream(enchantments).flatMap(Arrays::stream);
        }).mapToInt(enchantment -> enchantment.getMinEnchantAbility(enchantment.getLevel())).sum();
        resultExperience = ThreadLocalRandom.current().nextInt(NukkitMath.ceilDouble((double)resultExperience / 2.0), resultExperience + 1);
        this.setResultExperience(resultExperience);
    }

    @Override
    public Item getItem(int index) {
        if (index < 0 || index > 3) {
            return Item.get(0);
        }
        if (index == 2) {
            index = 34;
        }
        return super.getItem(index);
    }

    @Override
    public boolean setItem(int index, Item item, boolean send) {
        if (index < 0 || index > 3) {
            return false;
        }
        if (index == 2) {
            index = 34;
        }
        return super.setItem(index, item, send);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getResultExperience() {
        return this.resultExperience;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setResultExperience(int returnLevels) {
        this.resultExperience = returnLevels;
    }
}

